/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.web.filter;

import com.rollbar.notifier.Rollbar;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import com.rollbar.notifier.config.ConfigProvider;
import com.rollbar.notifier.config.ConfigProviderHelper;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.web.provider.PersonProvider;
import com.rollbar.web.provider.RequestProvider;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbarFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbarFilter.class);
    static final String ACCESS_TOKEN_PARAM_NAME = "access_token";
    static final String USER_IP_HEADER_PARAM_NAME = "user_ip_header";
    static final String CONFIG_PROVIDER_CLASS_PARAM_NAME = "config_provider";
    static final String CONFIG_IP_CAPTURE_PARAM_NAME = "capture_ip";
    private Rollbar rollbar;

    public RollbarFilter() {
    }

    public RollbarFilter(Rollbar rollbar) {
        this.rollbar = rollbar;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String accessToken = filterConfig.getInitParameter(ACCESS_TOKEN_PARAM_NAME);
        String userIpHeaderName = filterConfig.getInitParameter(USER_IP_HEADER_PARAM_NAME);
        String configProviderClassName = filterConfig.getInitParameter(CONFIG_PROVIDER_CLASS_PARAM_NAME);
        String captureIp = filterConfig.getInitParameter(CONFIG_IP_CAPTURE_PARAM_NAME);
        ConfigProvider configProvider = ConfigProviderHelper.getConfigProvider((String)configProviderClassName);
        RequestProvider requestProvider = new RequestProvider.Builder().userIpHeaderName(userIpHeaderName).captureIp(captureIp).build();
        ConfigBuilder configBuilder = ConfigBuilder.withAccessToken((String)accessToken).request((Provider)requestProvider).person((Provider)new PersonProvider());
        Config config = configProvider != null ? configProvider.provide(configBuilder) : configBuilder.build();
        this.rollbar = Rollbar.init((Config)config);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.sendToRollbar(e);
            throw e;
        }
    }

    private void sendToRollbar(Exception error) {
        try {
            this.rollbar.error((Throwable)error);
        }
        catch (Exception e) {
            LOGGER.error("Error sending to rollbar the error: ", (Object)error, (Object)e);
        }
    }

    public void destroy() {
        this.rollbar = null;
    }
}

