/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.SyndFeedInfo;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HashMapFeedInfoCache
implements FeedFetcherCache,
Serializable {
    private static final long serialVersionUID = 1L;
    static HashMapFeedInfoCache _instance;
    private Map<String, SyndFeedInfo> infoCache;

    public HashMapFeedInfoCache() {
        this.setInfoCache(this.createInfoCache());
    }

    public static synchronized FeedFetcherCache getInstance() {
        if (_instance == null) {
            _instance = new HashMapFeedInfoCache();
        }
        return _instance;
    }

    protected Map<String, SyndFeedInfo> createInfoCache() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected Object get(Object key) {
        return this.getInfoCache().get(key);
    }

    @Override
    public SyndFeedInfo getFeedInfo(URL feedUrl) {
        return (SyndFeedInfo)this.get(feedUrl.toString());
    }

    protected void put(String key, SyndFeedInfo value) {
        this.getInfoCache().put(key, value);
    }

    @Override
    public void setFeedInfo(URL feedUrl, SyndFeedInfo syndFeedInfo) {
        this.put(feedUrl.toString(), syndFeedInfo);
    }

    protected final synchronized Map<String, SyndFeedInfo> getInfoCache() {
        return this.infoCache;
    }

    protected final synchronized void setInfoCache(Map<String, SyndFeedInfo> map) {
        this.infoCache = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, SyndFeedInfo> map = this.infoCache;
        synchronized (map) {
            this.infoCache.clear();
        }
    }

    @Override
    public SyndFeedInfo remove(URL url) {
        if (url == null) {
            return null;
        }
        return this.infoCache.remove(url.toString());
    }
}

