/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.SyndFeedInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

public class DiskFeedInfoCache
implements FeedFetcherCache {
    protected String cachePath = null;

    public DiskFeedInfoCache(String cachePath) {
        this.cachePath = cachePath;
    }

    @Override
    public SyndFeedInfo getFeedInfo(URL url) {
        SyndFeedInfo info = null;
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(fileName);
            ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Attempting to read from cache", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Attempting to read from cache", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return info;
    }

    @Override
    public void setFeedInfo(URL url, SyndFeedInfo feedInfo) {
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(feedInfo);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Attempting to write to cache", e);
        }
    }

    public static String replaceNonAlphanumeric(String str, char subst) {
        char[] testChars;
        StringBuffer ret = new StringBuffer(str.length());
        for (char testChar : testChars = str.toCharArray()) {
            if (Character.isLetterOrDigit(testChar)) {
                ret.append(testChar);
                continue;
            }
            ret.append(subst);
        }
        return ret.toString();
    }

    @Override
    public synchronized void clear() {
        File file = new File(this.cachePath);
        if (file.exists() && file.canWrite()) {
            String[] files = file.list();
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                File deleteMe = new File(this.cachePath + File.separator + files[i]);
                deleteMe.delete();
            }
        }
    }

    @Override
    public SyndFeedInfo remove(URL url) {
        SyndFeedInfo info = null;
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        boolean consumed = false;
        try {
            fis = new FileInputStream(fileName);
            ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
            consumed = true;
        }
        catch (FileNotFoundException file) {
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Attempting to read from cache", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Attempting to read from cache", e);
        }
        finally {
            File file;
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (consumed && (file = new File(fileName)).exists()) {
                file.delete();
            }
        }
        return info;
    }
}

