/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import com.rometools.fetcher.FetcherException;
import com.rometools.fetcher.impl.AbstractFeedFetcher;
import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.SyndFeedInfo;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class HttpClientFeedFetcher
extends AbstractFeedFetcher {
    private CredentialSupplier credentialSupplier;
    private FeedFetcherCache feedInfoCache;
    private volatile HttpClientMethodCallbackIntf httpClientMethodCallback;
    private volatile HttpClientParams httpClientParams;

    public HttpClientFeedFetcher() {
        this.setHttpClientParams(new HttpClientParams());
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache) {
        this();
        this.setFeedInfoCache(cache);
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache, CredentialSupplier credentialSupplier) {
        this(cache);
        this.setCredentialSupplier(credentialSupplier);
    }

    public synchronized void setConnectTimeout(int timeout) {
        this.httpClientParams.setConnectionManagerTimeout((long)timeout);
    }

    public int getConnectTimeout() {
        return (int)this.getHttpClientParams().getConnectionManagerTimeout();
    }

    public synchronized void setCredentialSupplier(CredentialSupplier credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    public synchronized CredentialSupplier getCredentialSupplier() {
        return this.credentialSupplier;
    }

    public synchronized void setFeedInfoCache(FeedFetcherCache feedInfoCache) {
        this.feedInfoCache = feedInfoCache;
    }

    public synchronized FeedFetcherCache getFeedInfoCache() {
        return this.feedInfoCache;
    }

    public synchronized void setHttpClientMethodCallback(HttpClientMethodCallbackIntf httpClientMethodCallback) {
        this.httpClientMethodCallback = httpClientMethodCallback;
    }

    public HttpClientMethodCallbackIntf getHttpClientMethodCallback() {
        return this.httpClientMethodCallback;
    }

    public synchronized void setHttpClientParams(HttpClientParams httpClientParams) {
        this.httpClientParams = httpClientParams;
    }

    public synchronized HttpClientParams getHttpClientParams() {
        return this.httpClientParams;
    }

    public synchronized void setReadTimeout(int timeout) {
        this.httpClientParams.setSoTimeout(timeout);
    }

    public int getReadTimeout() {
        return this.getHttpClientParams().getSoTimeout();
    }

    @Override
    public SyndFeed retrieveFeed(URL url) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        return this.retrieveFeed(this.getUserAgent(), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyndFeed retrieveFeed(String userAgent, URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        FeedFetcherCache cache;
        Object authScope;
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        HttpClient client = new HttpClient(this.httpClientParams);
        if (this.getCredentialSupplier() != null) {
            client.getParams().setAuthenticationPreemptive(true);
            String host = feedUrl.getHost();
            Credentials credentials = this.getCredentialSupplier().getCredentials(null, host);
            if (credentials != null) {
                authScope = new AuthScope(host, -1);
                client.getState().setCredentials(authScope, credentials);
            }
        }
        System.setProperty("httpclient.useragent", userAgent);
        String urlStr = feedUrl.toString();
        GetMethod method = new GetMethod(urlStr);
        method.addRequestHeader("Accept-Encoding", "gzip");
        method.addRequestHeader("User-Agent", userAgent);
        method.setFollowRedirects(true);
        if (this.httpClientMethodCallback != null) {
            authScope = this.httpClientMethodCallback;
            synchronized (authScope) {
                this.httpClientMethodCallback.afterHttpClientMethodCreate((HttpMethod)method);
            }
        }
        if ((cache = this.getFeedInfoCache()) != null) {
            try {
                SyndFeedInfo syndFeedInfo;
                if (this.isUsingDeltaEncoding()) {
                    method.setRequestHeader("A-IM", "feed");
                }
                if ((syndFeedInfo = cache.getFeedInfo(feedUrl)) != null) {
                    method.setRequestHeader("If-None-Match", syndFeedInfo.getETag());
                    if (syndFeedInfo.getLastModified() instanceof String) {
                        method.setRequestHeader("If-Modified-Since", (String)syndFeedInfo.getLastModified());
                    }
                }
                int statusCode = client.executeMethod((HttpMethod)method);
                this.fireEvent("FEED_POLLED", urlStr);
                this.handleErrorCodes(statusCode);
                SyndFeed feed = this.getFeed(syndFeedInfo, urlStr, (HttpMethod)method, statusCode);
                syndFeedInfo = this.buildSyndFeedInfo(feedUrl, urlStr, (HttpMethod)method, feed, statusCode);
                cache.setFeedInfo(new URL(urlStr), syndFeedInfo);
                SyndFeed syndFeed = feed = syndFeedInfo.getSyndFeed();
                return syndFeed;
            }
            finally {
                method.releaseConnection();
            }
        }
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            this.fireEvent("FEED_POLLED", urlStr);
            this.handleErrorCodes(statusCode);
            SyndFeed syndFeed = this.getFeed(null, urlStr, (HttpMethod)method, statusCode);
            return syndFeed;
        }
        finally {
            method.releaseConnection();
        }
    }

    private SyndFeed getFeed(SyndFeedInfo syndFeedInfo, String urlStr, HttpMethod method, int statusCode) throws IOException, HttpException, FetcherException, FeedException {
        if (statusCode == 304 && syndFeedInfo != null) {
            this.fireEvent("FEED_UNCHANGED", urlStr);
            return syndFeedInfo.getSyndFeed();
        }
        SyndFeed feed = this.retrieveFeed(urlStr, method);
        this.fireEvent("FEED_RETRIEVED", urlStr, feed);
        return feed;
    }

    private SyndFeedInfo buildSyndFeedInfo(URL feedUrl, String urlStr, HttpMethod method, SyndFeed feed, int statusCode) throws MalformedURLException {
        Header eTagHeader;
        Header lastModifiedHeader;
        SyndFeedInfo cachedInfo;
        FeedFetcherCache cache;
        SyndFeedInfo syndFeedInfo = new SyndFeedInfo();
        syndFeedInfo.setUrl(new URL(urlStr));
        syndFeedInfo.setId(feedUrl.toString());
        Header imHeader = method.getResponseHeader("IM");
        if (imHeader != null && imHeader.getValue().indexOf("feed") >= 0 && this.isUsingDeltaEncoding() && (cache = this.getFeedInfoCache()) != null && statusCode == 226 && (cachedInfo = cache.getFeedInfo(feedUrl)) != null) {
            SyndFeed cachedFeed = cachedInfo.getSyndFeed();
            feed = HttpClientFeedFetcher.combineFeeds(cachedFeed, feed);
        }
        if ((lastModifiedHeader = method.getResponseHeader("Last-Modified")) != null) {
            syndFeedInfo.setLastModified(lastModifiedHeader.getValue());
        }
        if ((eTagHeader = method.getResponseHeader("ETag")) != null) {
            syndFeedInfo.setETag(eTagHeader.getValue());
        }
        syndFeedInfo.setSyndFeed(feed);
        return syndFeedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndFeed retrieveFeed(String urlStr, HttpMethod method) throws IOException, HttpException, FetcherException, FeedException {
        InputStream stream = null;
        stream = method.getResponseHeader("Content-Encoding") != null && "gzip".equalsIgnoreCase(method.getResponseHeader("Content-Encoding").getValue()) ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
        try {
            XmlReader reader = null;
            reader = method.getResponseHeader("Content-Type") != null ? new XmlReader(stream, method.getResponseHeader("Content-Type").getValue(), true) : new XmlReader(stream, true);
            SyndFeedInput syndFeedInput = new SyndFeedInput();
            syndFeedInput.setPreserveWireFeed(this.isPreserveWireFeed());
            SyndFeed syndFeed = syndFeedInput.build((Reader)reader);
            return syndFeed;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static interface HttpClientMethodCallbackIntf {
        public void afterHttpClientMethodCreate(HttpMethod var1);
    }

    public static interface CredentialSupplier {
        public Credentials getCredentials(String var1, String var2);
    }
}

