/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseHandler {
    public static final String defaultCharacterEncoding = "ISO-8859-1";
    private static final Pattern characterEncodingPattern = Pattern.compile("charset=([.[^; ]]*)");

    public static String getCharacterEncoding(URLConnection connection) {
        return ResponseHandler.getCharacterEncoding(connection.getContentType());
    }

    public static String getCharacterEncoding(String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return defaultCharacterEncoding;
        }
        Matcher m = characterEncodingPattern.matcher(contentTypeHeader);
        if (!m.find()) {
            return defaultCharacterEncoding;
        }
        return m.group(1);
    }
}

