/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.samples;

import com.rometools.fetcher.FetcherEvent;
import com.rometools.fetcher.FetcherListener;
import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.HashMapFeedInfoCache;
import com.rometools.fetcher.impl.HttpURLFeedFetcher;
import com.rometools.rome.feed.synd.SyndFeed;
import java.net.URL;

public class FeedReader {
    public static void main(String[] args) {
        boolean ok = false;
        if (args.length == 1) {
            try {
                URL feedUrl = new URL(args[0]);
                FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
                HttpURLFeedFetcher fetcher = new HttpURLFeedFetcher(feedInfoCache);
                FetcherEventListenerImpl listener = new FetcherEventListenerImpl();
                fetcher.addFetcherEventListener(listener);
                System.err.println("Retrieving feed " + feedUrl);
                SyndFeed feed = fetcher.retrieveFeed(feedUrl);
                System.err.println(feedUrl + " retrieved");
                System.err.println(feedUrl + " has a title: " + feed.getTitle() + " and contains " + feed.getEntries().size() + " entries.");
                System.err.println("Polling " + feedUrl + " again to test conditional get support.");
                fetcher.retrieveFeed(feedUrl);
                System.err.println("If a \"Feed Unchanged\" event fired then the server supports conditional gets.");
                ok = true;
            }
            catch (Exception ex) {
                System.out.println("ERROR: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
            System.out.println("The first parameter must be the URL of the feed to read.");
            System.out.println();
        }
    }

    static class FetcherEventListenerImpl
    implements FetcherListener {
        FetcherEventListenerImpl() {
        }

        @Override
        public void fetcherEvent(FetcherEvent event) {
            String eventType = event.getEventType();
            if ("FEED_POLLED".equals(eventType)) {
                System.err.println("\tEVENT: Feed Polled. URL = " + event.getUrlString());
            } else if ("FEED_RETRIEVED".equals(eventType)) {
                System.err.println("\tEVENT: Feed Retrieved. URL = " + event.getUrlString());
            } else if ("FEED_UNCHANGED".equals(eventType)) {
                System.err.println("\tEVENT: Feed Unchanged. URL = " + event.getUrlString());
            }
        }
    }
}

