/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.io.impl;

import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedParser;
import com.rometools.rome.io.impl.BaseWireFeedParser;
import com.rometools.rome.io.impl.DateParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPML10Parser
extends BaseWireFeedParser
implements WireFeedParser {
    private static Logger LOG = LoggerFactory.getLogger(OPML10Parser.class);

    public OPML10Parser() {
        super("opml_1.0", null);
    }

    public OPML10Parser(String type) {
        super(type, null);
    }

    public boolean isMyType(Document document) {
        Element e = document.getRootElement();
        return !(!e.getName().equals("opml") || e.getChild("head") != null && e.getChild("head").getChild("docs") != null || e.getAttributeValue("version") != null && !e.getAttributeValue("version").equals("1.0"));
    }

    public WireFeed parse(Document document, boolean validate, Locale locale) throws IllegalArgumentException, FeedException {
        Element root;
        Opml opml;
        block20: {
            opml = new Opml();
            opml.setFeedType("opml_1.0");
            root = document.getRootElement();
            Element head = root.getChild("head");
            if (head != null) {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    opml.setTitle(head.getChildText("title"));
                                    if (head.getChildText("dateCreated") != null) {
                                        opml.setCreated(DateParser.parseRFC822((String)head.getChildText("dateCreated"), (Locale)Locale.US));
                                    }
                                    if (head.getChildText("dateModified") != null) {
                                        opml.setModified(DateParser.parseRFC822((String)head.getChildText("dateModified"), (Locale)Locale.US));
                                    }
                                    opml.setOwnerName(head.getChildTextTrim("ownerName"));
                                    opml.setOwnerEmail(head.getChildTextTrim("ownerEmail"));
                                    opml.setVerticalScrollState(this.readInteger(head.getChildText("vertScrollState")));
                                    try {
                                        opml.setWindowBottom(this.readInteger(head.getChildText("windowBottom")));
                                    }
                                    catch (NumberFormatException nfe) {
                                        LOG.warn("Unable to parse windowBottom", (Throwable)nfe);
                                        if (!validate) break block15;
                                        throw new FeedException("Unable to parse windowBottom", (Throwable)nfe);
                                    }
                                }
                                try {
                                    opml.setWindowLeft(this.readInteger(head.getChildText("windowLeft")));
                                }
                                catch (NumberFormatException nfe) {
                                    LOG.warn("Unable to parse windowLeft", (Throwable)nfe);
                                    if (!validate) break block16;
                                    throw new FeedException("Unable to parse windowLeft", (Throwable)nfe);
                                }
                            }
                            try {
                                opml.setWindowRight(this.readInteger(head.getChildText("windowRight")));
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Unable to parse windowRight", (Throwable)nfe);
                                if (!validate) break block17;
                                throw new FeedException("Unable to parse windowRight", (Throwable)nfe);
                            }
                        }
                        try {
                            opml.setWindowLeft(this.readInteger(head.getChildText("windowLeft")));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.warn("Unable to parse windowLeft", (Throwable)nfe);
                            if (!validate) break block18;
                            throw new FeedException("Unable to parse windowLeft", (Throwable)nfe);
                        }
                    }
                    try {
                        opml.setWindowTop(this.readInteger(head.getChildText("windowTop")));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Unable to parse windowTop", (Throwable)nfe);
                        if (!validate) break block19;
                        throw new FeedException("Unable to parse windowTop", (Throwable)nfe);
                    }
                }
                try {
                    opml.setExpansionState(this.readIntArray(head.getChildText("expansionState")));
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Unable to parse expansionState", (Throwable)nfe);
                    if (!validate) break block20;
                    throw new FeedException("Unable to parse expansionState", (Throwable)nfe);
                }
            }
        }
        opml.setOutlines(this.parseOutlines(root.getChild("body").getChildren("outline"), validate, locale));
        opml.setModules(this.parseFeedModules(root, locale));
        return opml;
    }

    protected Outline parseOutline(Element e, boolean validate, Locale locale) throws FeedException {
        Outline outline;
        block7: {
            block6: {
                if (!e.getName().equals("outline")) {
                    throw new RuntimeException("Not an outline element.");
                }
                outline = new Outline();
                outline.setText(e.getAttributeValue("text"));
                outline.setType(e.getAttributeValue("type"));
                outline.setTitle(e.getAttributeValue("title"));
                List jAttributes = e.getAttributes();
                ArrayList<com.rometools.opml.feed.opml.Attribute> attributes = new ArrayList<com.rometools.opml.feed.opml.Attribute>();
                for (int i = 0; i < jAttributes.size(); ++i) {
                    Attribute a = (Attribute)jAttributes.get(i);
                    if (a.getName().equals("isBreakpoint") || a.getName().equals("isComment") || a.getName().equals("title") || a.getName().equals("text") || a.getName().equals("type")) continue;
                    attributes.add(new com.rometools.opml.feed.opml.Attribute(a.getName(), a.getValue()));
                }
                outline.setAttributes(attributes);
                try {
                    outline.setBreakpoint(this.readBoolean(e.getAttributeValue("isBreakpoint")));
                }
                catch (Exception ex) {
                    LOG.warn("Unable to parse isBreakpoint value", (Throwable)ex);
                    if (!validate) break block6;
                    throw new FeedException("Unable to parse isBreakpoint value", (Throwable)ex);
                }
            }
            try {
                outline.setComment(this.readBoolean(e.getAttributeValue("isComment")));
            }
            catch (Exception ex) {
                LOG.warn("Unable to parse isComment value", (Throwable)ex);
                if (!validate) break block7;
                throw new FeedException("Unable to parse isComment value", (Throwable)ex);
            }
        }
        List children = e.getChildren("outline");
        outline.setModules(this.parseItemModules(e, locale));
        outline.setChildren(this.parseOutlines(children, validate, locale));
        return outline;
    }

    protected List<Outline> parseOutlines(List<Element> elements, boolean validate, Locale locale) throws FeedException {
        ArrayList<Outline> results = new ArrayList<Outline>();
        for (int i = 0; i < elements.size(); ++i) {
            results.add(this.parseOutline(elements.get(i), validate, locale));
        }
        return results;
    }

    protected boolean readBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.getBoolean(value.trim());
    }

    protected int[] readIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(value, ",");
        int[] result = new int[tok.countTokens()];
        int count = 0;
        while (tok.hasMoreElements()) {
            result[count] = Integer.parseInt(tok.nextToken().trim());
            ++count;
        }
        return result;
    }

    protected Integer readInteger(String value) {
        if (value != null) {
            return new Integer(value);
        }
        return null;
    }
}

