/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.server.impl;

import com.rometools.propono.atom.common.Categories;
import com.rometools.propono.atom.common.Collection;
import com.rometools.propono.atom.common.rome.AppModule;
import com.rometools.propono.atom.common.rome.AppModuleImpl;
import com.rometools.propono.atom.server.AtomException;
import com.rometools.propono.atom.server.AtomMediaResource;
import com.rometools.propono.atom.server.AtomNotFoundException;
import com.rometools.propono.atom.server.impl.FileStore;
import com.rometools.propono.utils.Utilities;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.atom.Category;
import com.rometools.rome.feed.atom.Content;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedInput;
import com.rometools.rome.io.WireFeedOutput;
import com.rometools.rome.io.impl.Atom10Generator;
import com.rometools.rome.io.impl.Atom10Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;

@Deprecated
public class FileBasedCollection
extends Collection {
    private String handle = null;
    private String singular = null;
    private String collection = null;
    private boolean inlineCats = false;
    private String[] catNames = null;
    private boolean relativeURIs = false;
    private String contextURI = null;
    private String servletPath = null;
    private String baseDir = null;
    private static final String FEED_TYPE = "atom_1.0";

    public FileBasedCollection(String title, String handle, String collection, String singular, String accept, boolean inlineCats, String[] catNames, boolean relativeURIs, String contextURI, String contextPath, String servletPath, String baseDir) {
        super(title, "text", relativeURIs ? servletPath.substring(1) + "/" + handle + "/" + collection : contextURI + servletPath + "/" + handle + "/" + collection);
        this.handle = handle;
        this.collection = collection;
        this.singular = singular;
        this.inlineCats = inlineCats;
        this.catNames = catNames;
        this.baseDir = baseDir;
        this.relativeURIs = relativeURIs;
        this.contextURI = contextURI;
        this.servletPath = servletPath;
        this.addAccept(accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed getFeedDocument() throws AtomException {
        InputStream in = null;
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            in = FileStore.getFileStore().getFileInputStream(this.getFeedPath());
            if (in == null) {
                in = this.createDefaultFeedDocument(this.contextURI + this.servletPath + "/" + this.handle + "/" + this.collection);
            }
        }
        try {
            WireFeedInput input = new WireFeedInput();
            WireFeed wireFeed = input.build((Reader)new InputStreamReader(in, "UTF-8"));
            return (Feed)wireFeed;
        }
        catch (Exception ex) {
            throw new AtomException(ex);
        }
    }

    public List<Categories> getCategories(boolean inline) {
        Categories cats = new Categories();
        cats.setFixed(true);
        cats.setScheme(this.contextURI + "/" + this.handle + "/" + this.singular);
        if (inline) {
            for (String catName : this.catNames) {
                Category cat = new Category();
                cat.setTerm(catName);
                cats.addCategory(cat);
            }
        } else {
            cats.setHref(this.getCategoriesURI());
        }
        return Collections.singletonList(cats);
    }

    @Override
    public List<Categories> getCategories() {
        return this.getCategories(this.inlineCats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry addEntry(Entry entry) throws Exception {
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            Feed f = this.getFeedDocument();
            String fsid = FileStore.getFileStore().getNextId();
            this.updateTimestamps(entry);
            String entryPath = this.getEntryPath(fsid);
            OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
            this.updateEntryAppLinks(entry, fsid, true);
            Atom10Generator.serializeEntry((Entry)entry, (Writer)new OutputStreamWriter(os, "UTF-8"));
            os.flush();
            os.close();
            this.updateEntryAppLinks(entry, fsid, false);
            this.updateFeedDocumentWithNewEntry(f, entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addMediaEntry(Entry entry, String slug, InputStream is) throws Exception {
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            Content content = (Content)entry.getContents().get(0);
            if (entry.getTitle() == null) {
                entry.setTitle(slug);
            }
            String fileName = this.createFileName(slug != null ? slug : entry.getTitle(), content.getType());
            File tempFile = File.createTempFile(fileName, "tmp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            Utilities.copyInputToOutput(is, fos);
            fos.close();
            FileInputStream fis = new FileInputStream(tempFile);
            this.saveMediaFile(fileName, content.getType(), tempFile.length(), fis);
            fis.close();
            File resourceFile = new File(this.getEntryMediaPath(fileName));
            this.updateTimestamps(entry);
            String entryPath = this.getEntryPath(fileName);
            OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
            this.updateMediaEntryAppLinks(entry, resourceFile.getName(), true);
            Atom10Generator.serializeEntry((Entry)entry, (Writer)new OutputStreamWriter(os, "UTF-8"));
            os.flush();
            os.close();
            Feed f = this.getFeedDocument();
            this.updateMediaEntryAppLinks(entry, resourceFile.getName(), false);
            this.updateFeedDocumentWithNewEntry(f, entry);
            return this.getEntryEditURI(fileName, false, true);
        }
    }

    public Entry getEntry(String fsid) throws Exception {
        Entry entry;
        if (fsid.endsWith(".media-link")) {
            fsid = fsid.substring(0, fsid.length() - ".media-link".length());
        }
        String entryPath = this.getEntryPath(fsid);
        FileBasedCollection.checkExistence(entryPath);
        InputStream in = FileStore.getFileStore().getFileInputStream(entryPath);
        File resource = new File(fsid);
        if (resource.exists()) {
            entry = this.loadAtomResourceEntry(in, resource);
            this.updateMediaEntryAppLinks(entry, fsid, true);
        } else {
            entry = this.loadAtomEntry(in);
            this.updateEntryAppLinks(entry, fsid, true);
        }
        return entry;
    }

    public AtomMediaResource getMediaResource(String fileName) throws Exception {
        String filePath = this.getEntryMediaPath(fileName);
        File resource = new File(filePath);
        return new AtomMediaResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(Entry entry, String fsid) throws Exception {
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            Feed f = this.getFeedDocument();
            if (fsid.endsWith(".media-link")) {
                fsid = fsid.substring(0, fsid.length() - ".media-link".length());
            }
            this.updateTimestamps(entry);
            this.updateEntryAppLinks(entry, fsid, false);
            this.updateFeedDocumentWithExistingEntry(f, entry);
            String entryPath = this.getEntryPath(fsid);
            OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
            this.updateEntryAppLinks(entry, fsid, true);
            Atom10Generator.serializeEntry((Entry)entry, (Writer)new OutputStreamWriter(os, "UTF-8"));
            os.flush();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry updateMediaEntry(String fileName, String contentType, InputStream is) throws Exception {
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            File tempFile = File.createTempFile(fileName, "tmp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            Utilities.copyInputToOutput(is, fos);
            fos.close();
            FileInputStream fis = new FileInputStream(tempFile);
            this.saveMediaFile(fileName, contentType, tempFile.length(), fis);
            fis.close();
            File resourceFile = new File(this.getEntryMediaPath(fileName));
            String entryPath = this.getEntryPath(fileName);
            InputStream in = FileStore.getFileStore().getFileInputStream(entryPath);
            Entry atomEntry = this.loadAtomResourceEntry(in, resourceFile);
            this.updateTimestamps(atomEntry);
            this.updateMediaEntryAppLinks(atomEntry, fileName, false);
            Feed f = this.getFeedDocument();
            this.updateFeedDocumentWithExistingEntry(f, atomEntry);
            OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
            this.updateMediaEntryAppLinks(atomEntry, fileName, true);
            Atom10Generator.serializeEntry((Entry)atomEntry, (Writer)new OutputStreamWriter(os, "UTF-8"));
            os.flush();
            os.close();
            return atomEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(String fsid) throws Exception {
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            Feed feed = this.getFeedDocument();
            this.updateFeedDocumentRemovingEntry(feed, fsid);
            String entryFilePath = this.getEntryPath(fsid);
            FileStore.getFileStore().deleteFile(entryFilePath);
            String entryMediaPath = this.getEntryMediaPath(fsid);
            if (entryMediaPath != null) {
                FileStore.getFileStore().deleteFile(entryMediaPath);
            }
            String entryDirPath = this.getEntryDirPath(fsid);
            FileStore.getFileStore().deleteDirectory(entryDirPath);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateFeedDocumentWithNewEntry(Feed f, Entry e) throws AtomException {
        boolean inserted = false;
        for (int i = 0; i < f.getEntries().size(); ++i) {
            Entry entry = (Entry)f.getEntries().get(i);
            AppModule mod = (AppModule)entry.getModule("http://www.w3.org/2007/app");
            AppModule newMod = (AppModule)e.getModule("http://www.w3.org/2007/app");
            if (!newMod.getEdited().before(mod.getEdited())) continue;
            f.getEntries().add(i, e);
            inserted = true;
            break;
        }
        if (!inserted) {
            f.getEntries().add(0, e);
        }
        this.updateFeedDocument(f);
    }

    private void updateFeedDocumentRemovingEntry(Feed f, String id) throws AtomException {
        Entry e = this.findEntry("urn:uuid:" + id, f);
        f.getEntries().remove(e);
        this.updateFeedDocument(f);
    }

    private void updateFeedDocumentWithExistingEntry(Feed f, Entry e) throws AtomException {
        Entry old = this.findEntry(e.getId(), f);
        f.getEntries().remove(old);
        boolean inserted = false;
        for (int i = 0; i < f.getEntries().size(); ++i) {
            Entry entry = (Entry)f.getEntries().get(i);
            AppModule entryAppModule = (AppModule)entry.getModule("http://www.w3.org/2007/app");
            AppModule eAppModule = (AppModule)entry.getModule("http://www.w3.org/2007/app");
            if (!eAppModule.getEdited().before(entryAppModule.getEdited())) continue;
            f.getEntries().add(i, e);
            inserted = true;
            break;
        }
        if (!inserted) {
            f.getEntries().add(0, e);
        }
        this.updateFeedDocument(f);
    }

    private Entry findEntry(String id, Feed feed) {
        for (Entry entry : feed.getEntries()) {
            if (!id.equals(entry.getId())) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeedDocument(Feed f) throws AtomException {
        try {
            FileStore fileStore = FileStore.getFileStore();
            synchronized (fileStore) {
                WireFeedOutput wireFeedOutput = new WireFeedOutput();
                Document feedDoc = wireFeedOutput.outputJDom((WireFeed)f);
                XMLOutputter outputter = new XMLOutputter();
                OutputStream fos = FileStore.getFileStore().getFileOutputStream(this.getFeedPath());
                outputter.output(feedDoc, (Writer)new OutputStreamWriter(fos, "UTF-8"));
            }
        }
        catch (FeedException fex) {
            throw new AtomException(fex);
        }
        catch (IOException ex) {
            throw new AtomException(ex);
        }
    }

    private InputStream createDefaultFeedDocument(String uri) throws AtomException {
        Feed f = new Feed();
        f.setTitle("Feed");
        f.setId(uri);
        f.setFeedType(FEED_TYPE);
        Link selfLink = new Link();
        selfLink.setRel("self");
        selfLink.setHref(uri);
        f.getOtherLinks().add(selfLink);
        try {
            WireFeedOutput wireFeedOutput = new WireFeedOutput();
            Document feedDoc = wireFeedOutput.outputJDom((WireFeed)f);
            XMLOutputter outputter = new XMLOutputter();
            OutputStream fos = FileStore.getFileStore().getFileOutputStream(this.getFeedPath());
            outputter.output(feedDoc, (Writer)new OutputStreamWriter(fos, "UTF-8"));
        }
        catch (FeedException ex) {
            throw new AtomException(ex);
        }
        catch (IOException ex) {
            throw new AtomException(ex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileStore.getFileStore().getFileInputStream(this.getFeedPath());
    }

    private Entry loadAtomResourceEntry(InputStream in, File file) {
        try {
            Entry entry = Atom10Parser.parseEntry((Reader)new BufferedReader(new InputStreamReader(in)), null, (Locale)Locale.US);
            this.updateMediaEntryAppLinks(entry, file.getName(), true);
            return entry;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateEntryAppLinks(Entry entry, String fsid, boolean singleEntry) {
        entry.setId("urn:uuid:" + fsid);
        Link altLink = null;
        ArrayList<Link> altLinks = entry.getAlternateLinks();
        if (altLinks != null) {
            for (Link link : altLinks) {
                if (link.getRel() != null && !"alternate".equals(link.getRel())) continue;
                altLink = link;
                break;
            }
        } else {
            altLinks = new ArrayList<Link>();
            entry.setAlternateLinks(altLinks);
        }
        if (altLink == null) {
            altLink = new Link();
            altLinks.add(altLink);
        }
        altLink.setRel("alternate");
        altLink.setHref(this.getEntryViewURI(fsid));
        Link editLink = null;
        ArrayList<Link> otherLinks = entry.getOtherLinks();
        if (otherLinks != null) {
            for (Link link : otherLinks) {
                if (!"edit".equals(link.getRel())) continue;
                editLink = link;
                break;
            }
        } else {
            otherLinks = new ArrayList<Link>();
            entry.setOtherLinks(otherLinks);
        }
        if (editLink == null) {
            editLink = new Link();
            otherLinks.add(editLink);
        }
        editLink.setRel("edit");
        editLink.setHref(this.getEntryEditURI(fsid, this.relativeURIs, singleEntry));
    }

    private void updateMediaEntryAppLinks(Entry entry, String fileName, boolean singleEntry) {
        FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
        if (map instanceof MimetypesFileTypeMap) {
            try {
                ((MimetypesFileTypeMap)map).addMimeTypes("image/png png PNG");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entry.setId(this.getEntryMediaViewURI(fileName));
        entry.setTitle(fileName);
        entry.setUpdated(new Date());
        ArrayList<Link> otherlinks = new ArrayList<Link>();
        entry.setOtherLinks(otherlinks);
        Link editlink = new Link();
        editlink.setRel("edit");
        editlink.setHref(this.getEntryEditURI(fileName, this.relativeURIs, singleEntry));
        otherlinks.add(editlink);
        Link editMedialink = new Link();
        editMedialink.setRel("edit-media");
        editMedialink.setHref(this.getEntryMediaEditURI(fileName, this.relativeURIs, singleEntry));
        otherlinks.add(editMedialink);
        Content content = (Content)entry.getContents().get(0);
        content.setSrc(this.getEntryMediaViewURI(fileName));
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(content);
        entry.setContents(contents);
    }

    private Entry loadAtomEntry(InputStream in) {
        try {
            return Atom10Parser.parseEntry((Reader)new BufferedReader(new InputStreamReader(in, "UTF-8")), null, (Locale)Locale.US);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateTimestamps(Entry entry) {
        entry.setUpdated(new Date());
        AppModule appModule = (AppModule)entry.getModule("http://www.w3.org/2007/app");
        if (appModule == null) {
            appModule = new AppModuleImpl();
            List<AppModule> modules = entry.getModules() == null ? new ArrayList() : entry.getModules();
            modules.add(appModule);
            entry.setModules(modules);
        }
        appModule.setEdited(entry.getUpdated());
    }

    private void saveMediaFile(String name, String contentType, long size, InputStream is) throws AtomException {
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        File dirPath = new File(this.getEntryMediaPath(name));
        if (!dirPath.getParentFile().exists()) {
            dirPath.getParentFile().mkdirs();
        }
        OutputStream bos = null;
        try {
            bos = new FileOutputStream(dirPath.getAbsolutePath());
            while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new AtomException("ERROR uploading file", e);
        }
        finally {
            try {
                bos.flush();
                bos.close();
            }
            catch (Exception exception) {}
        }
    }

    private String createFileName(String title, String contentType) {
        if (this.handle == null) {
            throw new IllegalArgumentException("weblog handle cannot be null");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("contentType cannot be null");
        }
        String fileName = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHssSSS");
        String[] typeTokens = contentType.split("/");
        String ext = typeTokens[1];
        if (title != null && !title.trim().equals("")) {
            String base = Utilities.replaceNonAlphanumeric(title, ' ');
            StringTokenizer toker = new StringTokenizer(base);
            String tmp = null;
            for (int count = 0; toker.hasMoreTokens() && count < 5; ++count) {
                String s = toker.nextToken();
                s = s.toLowerCase();
                tmp = tmp == null ? s : tmp + "_" + s;
            }
            fileName = tmp + "-" + sdf.format(new Date()) + "." + ext;
        } else {
            fileName = this.handle + "-" + sdf.format(new Date()) + "." + ext;
        }
        return fileName;
    }

    private String getEntryEditURI(String fsid, boolean relative, boolean singleEntry) {
        String entryURI = null;
        entryURI = relative ? (singleEntry ? fsid : this.singular + "/" + fsid) : this.contextURI + this.servletPath + "/" + this.handle + "/" + this.singular + "/" + fsid;
        return entryURI;
    }

    private String getEntryViewURI(String fsid) {
        return this.contextURI + "/" + this.handle + "/" + this.collection + "/" + fsid + "/entry.xml";
    }

    private String getEntryMediaEditURI(String fsid, boolean relative, boolean singleEntry) {
        String entryURI = null;
        entryURI = relative ? (singleEntry ? "media/" + fsid : this.singular + "/media/" + fsid) : this.contextURI + this.servletPath + "/" + this.handle + "/" + this.singular + "/media/" + fsid;
        return entryURI;
    }

    private String getEntryMediaViewURI(String fsid) {
        return this.contextURI + "/" + this.handle + "/" + this.collection + "/" + fsid + "/media/" + fsid;
    }

    private String getCategoriesURI() {
        if (!this.relativeURIs) {
            return this.contextURI + this.servletPath + "/" + this.handle + "/" + this.singular + "/categories";
        }
        return this.servletPath + "/" + this.handle + "/" + this.singular + "/categories";
    }

    private String getBaseDir() {
        return this.baseDir;
    }

    private String getFeedPath() {
        return this.getBaseDir() + this.handle + File.separator + this.collection + File.separator + "feed.xml";
    }

    private String getEntryDirPath(String id) {
        return this.getBaseDir() + this.handle + File.separator + this.collection + File.separator + id;
    }

    private String getEntryPath(String id) {
        return this.getEntryDirPath(id) + File.separator + "entry.xml";
    }

    private String getEntryMediaPath(String id) {
        return this.getEntryDirPath(id) + File.separator + "media" + File.separator + id;
    }

    private static void checkExistence(String path) throws AtomNotFoundException {
        if (!FileStore.getFileStore().exists(path)) {
            throw new AtomNotFoundException("Entry does not exist");
        }
    }
}

