/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.blogclient;

import com.rometools.propono.blogclient.BlogClientException;
import com.rometools.propono.blogclient.BlogConnection;
import java.lang.reflect.Constructor;

@Deprecated
public class BlogConnectionFactory {
    private static String ATOMPROTOCOL_IMPL_CLASS = "com.rometools.propono.blogclient.atomprotocol.AtomConnection";
    private static String METAWEBLOG_IMPL_CLASS = "com.rometools.propono.blogclient.metaweblog.MetaWeblogConnection";

    private BlogConnectionFactory() {
    }

    public static BlogConnection getBlogConnection(String type, String url, String username, String password) throws BlogClientException {
        BlogConnection blogConnection = null;
        if (type == null || type.equals("metaweblog")) {
            blogConnection = BlogConnectionFactory.createBlogConnection(METAWEBLOG_IMPL_CLASS, url, username, password);
        } else if (type.equals("atom")) {
            blogConnection = BlogConnectionFactory.createBlogConnection(ATOMPROTOCOL_IMPL_CLASS, url, username, password);
        } else {
            throw new BlogClientException("Type must be 'atom' or 'metaweblog'");
        }
        return blogConnection;
    }

    private static BlogConnection createBlogConnection(String className, String url, String username, String password) throws BlogClientException {
        Class<?> conClass;
        try {
            conClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new BlogClientException("BlogConnection impl. class not found: " + className, ex);
        }
        Class[] args = new Class[]{String.class, String.class, String.class};
        try {
            Constructor<?> ctor = conClass.getConstructor(args);
            return (BlogConnection)ctor.newInstance(url, username, password);
        }
        catch (Throwable t) {
            throw new BlogClientException("ERROR instantiating BlogConnection impl.", t);
        }
    }
}

