/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaObjectNamespace
extends Namespace {
    public Object obj;
    public ObjectDumpConfig objectDumpConfig;

    public JavaObjectNamespace(Object obj) {
        this.obj = obj;
        this.objectDumpConfig = ObjectDumpConfig.GetDefaultDumpConfig();
    }

    public JavaObjectNamespace(Object obj, ObjectDumpConfig objectDumpConfig) {
        this.obj = obj;
        this.objectDumpConfig = objectDumpConfig;
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "type": {
                return new JavaObjectNamespace(this.obj.getClass().toString());
            }
            case "size": {
                if (null != this.obj) {
                    if (this.obj.getClass().isArray()) {
                        return new JavaObjectNamespace(Array.getLength(this.obj));
                    }
                    if (this.obj instanceof Collection) {
                        return new JavaObjectNamespace(((Collection)this.obj).size());
                    }
                    if (this.obj instanceof Map) {
                        return new JavaObjectNamespace(((Map)this.obj).size());
                    }
                    throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "size()");
                }
                throw new Exceptions.RookInvalidObjectForAccess(null, "size()");
            }
            case "depth": {
                try {
                    this.objectDumpConfig.max_depth = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("depth()", args);
                }
                return this;
            }
            case "width": {
                try {
                    this.objectDumpConfig.max_width = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("width()", args);
                }
                return this;
            }
            case "collection_dump": {
                try {
                    this.objectDumpConfig.max_collection_depth = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("collection_dump()", args);
                }
                return this;
            }
            case "string": {
                try {
                    this.objectDumpConfig.max_string = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("string()", args);
                }
                return this;
            }
            case "limit": {
                this.objectDumpConfig = ObjectDumpConfig.GetObjectDumpConfig(args.toLowerCase());
                if (this.objectDumpConfig == null) {
                    throw new Exceptions.RookInvalidMethodArguments("limit()", args);
                }
                return this;
            }
        }
        return super.CallMethod(name, args);
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        Field field = null;
        Class<?> cls = this.obj instanceof Class ? (Class<?>)this.obj : this.obj.getClass();
        while (true) {
            try {
                field = cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (null != (cls = cls.getSuperclass())) continue;
            }
            break;
        }
        if (field == null) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        try {
            field.setAccessible(true);
            return new JavaObjectNamespace(field.get(this.obj));
        }
        catch (Throwable e) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
    }

    @Override
    public Namespace ReadKey(Object key) throws Exceptions.ToolException {
        if (this.obj.getClass().isArray()) {
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= Array.getLength(this.obj)) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(Array.get(this.obj, index));
        }
        if (this.obj instanceof List) {
            List listObj = (List)this.obj;
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= listObj.size()) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(listObj.get(index));
        }
        if (this.obj instanceof Map) {
            Map mapObj = (Map)this.obj;
            if (!mapObj.containsKey(key)) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(mapObj.get(key));
        }
        throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
    }

    public boolean IsDefaultDumpConfig() {
        return this.objectDumpConfig.max_depth == 4 && this.objectDumpConfig.max_width == 20 && this.objectDumpConfig.max_collection_depth == 2 && this.objectDumpConfig.max_string == 512;
    }

    public static class ObjectDumpConfig {
        public static final int STRICT_MAX_DEPTH = 2;
        public static final int STRICT_MAX_WIDTH = 10;
        public static final int STRICT_MAX_COLLECTION_DEPTH = 1;
        public static final int STRICT_MAX_STRING = 128;
        public static final int DEFAULT_MAX_DEPTH = 4;
        public static final int DEFAULT_MAX_WIDTH = 20;
        public static final int DEFAULT_MAX_COLLECTION_DEPTH = 2;
        public static final int DEFAULT_MAX_STRING = 512;
        public static final int TOLERANT_MAX_DEPTH = 5;
        public static final int TOLERANT_MAX_WIDTH = 50;
        public static final int TOLERANT_MAX_COLLECTION_DEPTH = 4;
        public static final int TOLERANT_MAX_STRING = 4096;
        public static final int UNLIMITED_MAX_STRING = 65536;
        public static final int UNLIMITED_MAX_COLLECTION_WIDTH = 100;
        static final Map<String, ObjectDumpConfig> dumpConfigs;
        public int max_depth;
        public int max_width;
        public int max_collection_depth;
        public int max_string;

        public static ObjectDumpConfig GetObjectDumpConfig(String key) {
            return dumpConfigs.get(key);
        }

        public ObjectDumpConfig(int max_depth, int max_width, int max_collection_depth, int max_string) {
            this.max_depth = max_depth;
            this.max_width = max_width;
            this.max_collection_depth = max_collection_depth;
            this.max_string = max_string;
        }

        public static ObjectDumpConfig GetStrictDumpConfig() {
            return new ObjectDumpConfig(2, 10, 1, 128);
        }

        public static ObjectDumpConfig GetDefaultDumpConfig() {
            return new ObjectDumpConfig(4, 20, 2, 512);
        }

        public static ObjectDumpConfig GetTolerantDumpConfig() {
            return new ObjectDumpConfig(5, 50, 4, 4096);
        }

        public static ObjectDumpConfig TailorLimits(Object object) {
            if (object instanceof String) {
                return new ObjectDumpConfig(1, 0, 0, 65536);
            }
            if (object instanceof Collection || object instanceof Map) {
                return new ObjectDumpConfig(4, 100, 2, 512);
            }
            return ObjectDumpConfig.GetDefaultDumpConfig();
        }

        static {
            HashMap<String, ObjectDumpConfig> modifiableMap = new HashMap<String, ObjectDumpConfig>();
            modifiableMap.put("strict", ObjectDumpConfig.GetStrictDumpConfig());
            modifiableMap.put("default", ObjectDumpConfig.GetDefaultDumpConfig());
            modifiableMap.put("tolerant", ObjectDumpConfig.GetTolerantDumpConfig());
            dumpConfigs = Collections.unmodifiableMap(modifiableMap);
        }
    }
}

