/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.StackTrace;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StackWalkerLock {
    public static ReadWriteLock lock;

    static {
        String javaSpecVersion = System.getProperty("java.specification.version");
        String[] versions = new String[]{"9", "10", "11"};
        lock = new ReadWriteLock(){

            @Override
            public Lock readLock() {
                return new NoOpLock();
            }

            @Override
            public Lock writeLock() {
                return new NoOpLock();
            }
        };
        try {
            if (Arrays.asList(versions).contains(javaSpecVersion)) {
                String javaVersion = System.getProperty("java.version");
                String[] versionComponents = javaVersion.split("\\.");
                int major = Integer.parseInt(versionComponents[0]);
                int minor = Integer.parseInt(versionComponents[1]);
                int patch = Integer.parseInt(versionComponents[2]);
                if (major < 11 || major == 11 && minor == 0 && patch < 4) {
                    lock = new ReentrantReadWriteLock();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class NoOpLock
    implements Lock {
        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

