/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs.Locations;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.TriggerServices;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import rook.org.json.JSONObject;

public class LocationFileLine
implements Location {
    public static final String NAME = "file_line";
    private static final String COLD_FUSION_ROOT_DIR_ENV = "CF_WWWROOT";
    private String filename = null;
    private String module_name = null;
    private Integer lineno;
    private HashInfo hashInfo;

    public LocationFileLine(String arguments, ProcessorFactory processorFactory) {
        this(new JSONObject(arguments), processorFactory);
    }

    public LocationFileLine(JSONObject arguments, ProcessorFactory processorFactory) {
        if (arguments.has("filename")) {
            this.filename = arguments.getString("filename");
        }
        if (null == this.filename) {
            this.module_name = arguments.getString("module_name");
        }
        this.lineno = arguments.getInt("lineno");
        String file_hash = null;
        Long line_crc = null;
        Boolean line_crc_unique = null;
        if (arguments.has("sha256")) {
            file_hash = arguments.getString("sha256");
        }
        if (arguments.has("line_crc32_2")) {
            line_crc = Long.decode("0x" + arguments.getString("line_crc32_2"));
        }
        if (arguments.has("line_unique")) {
            line_crc_unique = arguments.getBoolean("line_unique");
        }
        this.hashInfo = new HashInfo(file_hash, this.lineno, line_crc, line_crc_unique);
    }

    @Override
    public void AddAug(TriggerServices triggerServices, Aug aug) throws Exception {
        try {
            triggerServices.getInstrumentation().AddAug(Paths.get(this.filename, new String[0]).getFileName().toString(), this.lineno, this.hashInfo, aug);
        }
        catch (InvalidPathException e) {
            throw new Exceptions.RookInvalidObjectConfiguration("filename", this.filename, (Throwable)e);
        }
    }
}

