/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import java.util.HashMap;

public class Exceptions {

    public static class RookCrcMismatchException
    extends ToolException {
        public RookCrcMismatchException(String filePath, Long expected, Long calculated) {
            super(String.format("Line CRC32s do not match! path: %s, expected: 0x%x, calculated: 0x%x", filePath, expected, calculated));
            this.parameters.put("filepath", filePath);
            this.parameters.put("expected", String.format("%x", expected));
            this.parameters.put("calculated", String.format("%x", calculated));
        }
    }

    public static class RookLineMoved
    extends ToolException {
        public RookLineMoved(String filePath, int oldLineNo, int newLineNo) {
            super(String.format("Line has moved! path: %s, original line no: %s, new line no: %s", filePath, oldLineNo, newLineNo));
            this.parameters.put("filepath", filePath);
            this.parameters.put("old_line_no", oldLineNo);
            this.parameters.put("new_line_no", newLineNo);
        }
    }

    public static class RookExceptionEvaluationFailed
    extends ToolException {
        public RookExceptionEvaluationFailed(String expression) {
            super(String.format("Failed to evaluate expression: %s", expression));
            this.parameters.put("expression", expression);
        }
    }

    public static class RookNonPrimitiveObjectType
    extends ToolException {
        public RookNonPrimitiveObjectType(String path) {
            super(String.format("Object '%s' must be of primitive type, such as: string, int, long etc", path));
            this.parameters.put("path", path);
        }
    }

    public static class RookInvalidKeyType
    extends ToolException {
        public RookInvalidKeyType(Object key, String expected) {
            super("Invalid key type");
            this.parameters.put("key", key);
            this.parameters.put("expected", expected);
        }
    }

    public static class RookInvalidLabel
    extends ToolException {
        public RookInvalidLabel(String label) {
            super("Invalid label: must not start with the '$' character");
            this.parameters.put("label", label);
        }
    }

    public static class RookInvalidOptions
    extends ToolException {
        public RookInvalidOptions(String message) {
            super(message);
        }
    }

    public static class RookInvalidArithmeticPath
    extends ToolException {
        public RookInvalidArithmeticPath(String configuration, Exception innerException) {
            super(String.format("Invalid arithmetic path configuration. configuration: %s, innerException: %s", configuration, innerException));
            this.parameters.put("configuration", configuration);
            this.parameters.put("innerException", innerException);
        }
    }

    public static class RookInvalidPositionException
    extends ToolException {
        public RookInvalidPositionException() {
            super("Code position is not breakable");
        }
    }

    public static class RookMissingToken
    extends ToolException {
        public RookMissingToken() {
            super("No Rookout token was supplied. Make sure to pass the Rookout Token when starting the rook");
        }
    }

    public static class RookInvalidToken
    extends ToolException {
        public RookInvalidToken() {
            super("The Rookout token supplied is not valid; please check the token and try again");
        }

        public RookInvalidToken(String token) {
            super(String.format("The Rookout token supplied (%s...) is not valid; please check the token and try again", token.substring(0, 6)));
        }
    }

    public static class RookUnsupportedLocation
    extends ToolException {
        public RookUnsupportedLocation(String name) {
            super(String.format("Unsupported aug location was specified: %s", name));
            this.parameters.put("location", name);
        }
    }

    public static class RookJVMVersionParsingFailed
    extends ToolException {
        public RookJVMVersionParsingFailed(String jvmVersion) {
            super(String.format("Failed to parse JVM version: %s", jvmVersion));
            this.parameters.put("jvmVersion", jvmVersion);
        }
    }

    public static class RookFailedToLoadOpenSsl
    extends ToolException {
        public RookFailedToLoadOpenSsl() {
            super("In some alpine environment Openssl fails to load");
        }
    }

    public static class RookUnSupportedEnvironment
    extends ToolException {
        public RookUnSupportedEnvironment(String jvmVersion, String distributionName, int updateVersion) {
            super(String.format("Rook is not supported in this environment: JVM version %s update %d, distribution %s", jvmVersion, updateVersion, distributionName));
            this.parameters.put("jvmVersion", jvmVersion);
            this.parameters.put("updateVersion", updateVersion);
            this.parameters.put("distribution", distributionName);
        }
    }

    public static class RookRuleMaxExecutionTimeReached
    extends ToolException {
        public RookRuleMaxExecutionTimeReached() {
            super("Breakpoint was disabled because it has reached its maximum execution time");
        }
    }

    public static class RookRuleRateLimited
    extends ToolException {
        public RookRuleRateLimited() {
            super("Breakpoint was disabled due to rate-limiting. For more information: https://docs.rookout.com/docs/breakpoints-tasks.html#rate-limiting");
        }
    }

    public static class RookLoggingServiceUnavailable
    extends ToolException {
        public RookLoggingServiceUnavailable() {
            super("JVM Logging service is unavailable");
        }
    }

    public static class RookInstrumentationUnavailable
    extends ToolException {
        public RookInstrumentationUnavailable() {
            super("JVM Instrumentation is unavailable");
        }
    }

    public static class RookOperationReadOnly
    extends ToolException {
        public RookOperationReadOnly(Class operation) {
            super(String.format("Operation '%s' does not support write", operation.toString()));
            this.parameters.put("operation", operation.toString());
        }
    }

    public static class RookMethodFailed
    extends ToolException {
        public RookMethodFailed(String method, String arguments, Throwable t) {
            super(String.format("Namespace method '%s' failed with args %s", method, arguments), t);
            this.parameters.put("method", method);
            this.parameters.put("arguments", arguments);
        }
    }

    public static class RookInvalidMethodArguments
    extends ToolException {
        public RookInvalidMethodArguments(String method, String arguments) {
            super(String.format("Bad method arguments: method: %s, args %s", method, arguments));
            this.parameters.put("method", method);
            this.parameters.put("arguments", arguments);
        }
    }

    public static class RookInvalidObjectForAccess
    extends ToolException {
        public RookInvalidObjectForAccess(Class object_type, String access) {
            super(String.format("Namespace does not support access %s", access));
            if (null != object_type) {
                this.parameters.put("object", object_type.toString());
            } else {
                this.parameters.put("object", null);
            }
            this.parameters.put("access", access);
        }
    }

    public static class RookWriteAttributeNotSupported
    extends ToolException {
        public RookWriteAttributeNotSupported(Class namespace_type, String attribute) {
            super(String.format("Namespace %s does not support write", namespace_type.toString()));
            this.parameters.put("namespace", namespace_type.toString());
            this.parameters.put("attribute", attribute);
        }
    }

    public static class RookMethodNotFound
    extends ToolException {
        public RookMethodNotFound(Class namespace_type, String method) {
            super(String.format("Namespace method %s not found in namespace %s", method, namespace_type.toString()));
            this.parameters.put("namespace", namespace_type.toString());
            this.parameters.put("method", method);
        }
    }

    public static class RookKeyNotFound
    extends ToolException {
        public RookKeyNotFound(Object key) {
            super(String.format("Failed to get key %s", key));
            this.parameters.put("key", key);
        }
    }

    public static class RookAttributeNotFound
    extends ToolException {
        public RookAttributeNotFound(String attribute) {
            super(String.format("Failed to get attribute %s", attribute));
            this.parameters.put("attribute", attribute);
        }
    }

    public static class RookMultipleSoruceFilesFound
    extends ToolException {
        public RookMultipleSoruceFilesFound(String file_name) {
            super(String.format("Multiple files found %s", file_name));
            this.parameters.put("file_name", file_name);
        }
    }

    public static class RookSourceFileNotFound
    extends ToolException {
        public RookSourceFileNotFound(String file_name) {
            super(String.format("Failed to find file %s", file_name));
            this.parameters.put("file_name", file_name);
        }
    }

    public static class RookHashCalculationFailed
    extends ToolException {
        public RookHashCalculationFailed(String file_name, String class_name, Throwable e) {
            super(String.format("Hash calculation failed due to unknown error %s:%s", file_name, class_name));
            this.parameters.put("file_name", file_name);
            this.parameters.put("class_name", class_name);
            this.parameters.put("throwable", e);
        }
    }

    public static class RookSourceMissing
    extends ToolException {
        public RookSourceMissing(String file_name, String class_name) {
            super(String.format("Source location could not be determined %s:%s", file_name, class_name));
            this.parameters.put("filename", file_name);
            this.parameters.put("class_name", class_name);
        }
    }

    public static class RookInvalidObjectConfiguration
    extends ToolException {
        public RookInvalidObjectConfiguration(String object_name, String object_config, Throwable cause) {
            super(String.format("Invalid object '%s' configuration: %s", object_name, object_config), cause);
            this.parameters.put("object_name", object_name);
            this.parameters.put("object_config", object_config);
        }
    }

    public static class RookObjectNameMissing
    extends ToolException {
        public RookObjectNameMissing(String configuration, Throwable cause) {
            super(String.format("Failed to find object name %s", configuration), cause);
            this.parameters.put("configuration", configuration);
        }
    }

    public static class RookAugInvalidKey
    extends ToolException {
        public RookAugInvalidKey(String key, String configuration, Throwable cause) {
            super(String.format("Failed to get key %s from configuration %s", key, configuration), cause);
            this.parameters.put("key", key);
            this.parameters.put("configuration", configuration);
        }
    }

    public static class RookHashMismatchException
    extends ToolException {
        public RookHashMismatchException(String filepath, String expected, String calculated) {
            super(String.format("File hashes do not match! path: %s, expected: %s, calculated: %s", filepath, expected, calculated));
            this.parameters.put("filepath", filepath);
            this.parameters.put("expected", expected);
            this.parameters.put("calculated", calculated);
        }
    }

    public static abstract class ToolException
    extends Exception {
        protected HashMap<String, Object> parameters = new HashMap();

        public ToolException() {
        }

        public ToolException(String message) {
            super(message);
        }

        public ToolException(Throwable cause) {
            super(cause);
        }

        public ToolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ToolException(String message, HashMap<String, Object> parameters) {
            super(message);
            this.parameters = parameters;
        }

        public ToolException(String message, HashMap<String, Object> parameters, Throwable cause) {
            super(message, cause);
            this.parameters = parameters;
        }

        public String getType() {
            return this.getClass().getSimpleName();
        }

        public HashMap getParameters() {
            return this.parameters;
        }
    }
}

