/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.ClassReloader;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.IClassReloader;
import com.rookout.rook.Services.Instrumentation.NoopClassReloader;
import com.rookout.rook.Services.Instrumentation.Visitor;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassWriter;

public class InstrumentationService
implements ClassFileTransformer {
    private final ArrayList<String> includedPrefixes;
    private final ArrayList<String> whitelistPrefix;
    private final ArrayList<String> initialIncludedPrefixes = new ArrayList<String>(){
        {
            this.add("org.apache.beam");
        }
    };
    private final ArrayList<String> excludedPrefixes = new ArrayList<String>(){
        {
            this.add("com.sun.");
            this.add("java.");
            this.add("jdk.");
            this.add("sun.");
            this.add("lambdainternal.");
            this.add("worker.org.gradle.");
            this.add("org.springframework.");
            this.add("org.eclipse.");
            this.add("org.apache.");
            this.add("com.rookout.rook.");
            this.add("com.rookout.agent.");
            this.add("com.microsoft.azure.");
            this.add("rook.");
            this.add("io.netty.");
        }
    };
    private final ArrayList<String> excludedSuffixes = new ArrayList<String>(){
        {
            this.add("io.netty.util.internal.logging.Log4JLogger");
        }
    };
    private final ArrayList<String> excludedContains = new ArrayList<String>(){
        {
            this.add("$Lambda$");
        }
    };
    private Augs augs = new Augs();
    private Files files = new Files();
    public boolean silencedRetransformFailure = false;
    public static InstrumentationService instance;
    private static Instrumentation inst;
    private IClassReloader classReloader = null;
    private static boolean shouldReloadAllClassesOnStart;
    private static boolean disableClassTransform;

    public static void SetInstrumentation(Instrumentation instrumentation, boolean shouldReloadAllClassesOnStartArg, boolean disableClassTransformArg) {
        inst = instrumentation;
        shouldReloadAllClassesOnStart = shouldReloadAllClassesOnStartArg;
        disableClassTransform = disableClassTransformArg;
    }

    public static InstrumentationService Build() {
        if (null == inst) {
            RookLogger.Instance().log(Level.WARNING, "Java agent was not initialized, instrumentation not available");
            return null;
        }
        if (null != instance) {
            throw new RuntimeException("Cannot create multiple instances!");
        }
        instance = new InstrumentationService();
        return instance;
    }

    public void ResetClassReloader() {
        if (null != this.classReloader) {
            this.classReloader.Stop();
            this.classReloader = null;
        }
        this.classReloader = new ClassReloader(inst, this.augs, this.files);
    }

    public void Close() {
        if (disableClassTransform) {
            return;
        }
        this.classReloader.Stop();
        this.ClearAugs();
        inst.removeTransformer(this);
        CallbackDispatcher.Close();
        instance = null;
    }

    public void AddAug(String fileName, int lineno, HashInfo hashInfo, Aug aug) throws Exception {
        this.classReloader.AddAug(fileName, lineno, hashInfo, aug);
    }

    public void RemoveAug(String augId) {
        this.classReloader.RemoveAug(augId);
    }

    public void ClearAugs() {
        Set<String> augIds = this.augs.AllAugIds();
        for (String augId : augIds) {
            try {
                this.RemoveAug(augId);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while removing aug", e, new Object[0]);
            }
        }
    }

    private InstrumentationService() {
        this.includedPrefixes = new ArrayList();
        this.whitelistPrefix = new ArrayList();
        String include_class_prefix = Utils.GetConfigurationString("ROOKOUT_INCLUDE_CLASS_PREFIX");
        if (include_class_prefix != null) {
            Collections.addAll(this.includedPrefixes, include_class_prefix.split(","));
        }
        for (String prefix : this.initialIncludedPrefixes) {
            this.includedPrefixes.add(prefix);
        }
        String whitelisted_class_prefix = Utils.GetConfigurationString("ROOKOUT_WHITELIST_CLASS_PREFIX");
        if (whitelisted_class_prefix != null) {
            Collections.addAll(this.whitelistPrefix, whitelisted_class_prefix.split(","));
        }
        if (disableClassTransform) {
            this.classReloader = new NoopClassReloader();
            return;
        }
        CallbackDispatcher.CreateCallbackDispatcher(this.augs);
        inst.addTransformer(this, true);
        this.finalizeAllNamespaceArrays();
        if (shouldReloadAllClassesOnStart) {
            this.ReloadAllClasses();
        }
        this.ResetClassReloader();
    }

    private void finalizeAllNamespaceArrays() {
        this.finalizeNamespaceArray(this.includedPrefixes);
        this.finalizeNamespaceArray(this.whitelistPrefix);
        this.finalizeNamespaceArray(this.excludedPrefixes);
        this.finalizeNamespaceArray(this.excludedContains);
        this.finalizeNamespaceArray(this.excludedSuffixes);
        this.finalizeNamespaceArray(this.initialIncludedPrefixes);
    }

    private void finalizeNamespaceArray(ArrayList<String> arr) {
        ArrayList<String> copy = new ArrayList<String>(arr);
        for (String c : copy) {
            arr.add(c.replace('.', '/'));
        }
    }

    private boolean IsClassExcluded(String className) {
        if (this.whitelistPrefix.size() != 0) {
            for (String whitelistedPrefix : this.whitelistPrefix) {
                if (!className.startsWith(whitelistedPrefix)) continue;
                return false;
            }
            return true;
        }
        for (String prefix : this.excludedPrefixes) {
            if (!className.startsWith(prefix)) continue;
            for (String included_prefix : this.includedPrefixes) {
                if (!className.startsWith(included_prefix)) continue;
                return false;
            }
            return true;
        }
        for (String prefix : this.excludedSuffixes) {
            if (!className.endsWith(prefix)) continue;
            return true;
        }
        for (String pattern : this.excludedContains) {
            if (!className.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private void ReloadAllClasses() {
        Class[] classes = inst.getAllLoadedClasses();
        RookLogger.Instance().debug("Reloading " + classes.length + " classes", new Object[0]);
        int i = 1;
        for (Class cls : classes) {
            String className = "";
            if (i % 1000 == 0) {
                RookLogger.Instance().debug(i + " classes transformed", new Object[0]);
            }
            ++i;
            try {
                className = cls.getName();
                if (!inst.isModifiableClass(cls) || cls.getProtectionDomain() == null || className == null || this.IsClassExcluded(className)) continue;
                inst.retransformClasses(cls);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to retransform class: " + className, e, new Object[0]);
                this.silencedRetransformFailure = true;
            }
        }
        RookLogger.Instance().debug("Done reloading classes", new Object[0]);
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (null == className || null == protectionDomain || this.IsClassExcluded(className)) {
                return null;
            }
            URL location = null;
            if (protectionDomain.getCodeSource() != null) {
                location = protectionDomain.getCodeSource().getLocation();
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 0);
            Visitor visitor = new Visitor(this.files, this.augs, classLoader, className, location, writer);
            try {
                reader.accept(visitor, 0);
            }
            catch (Visitor.IgnoreClassException e) {
                return null;
            }
            if (!visitor.isHooked()) {
                return null;
            }
            return writer.toByteArray();
        }
        catch (Throwable e) {
            this.silencedRetransformFailure = true;
            String message = "Failed to transform class: " + className;
            RookLogger.Instance().log(Level.WARNING, message, e, new Object[0]);
            UserWarnings.SendError(new RookError(e, message));
            return null;
        }
    }

    static {
        shouldReloadAllClassesOnStart = false;
        disableClassTransform = false;
    }
}

