/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.APILoader;
import com.rookout.rook.Config;
import com.rookout.rook.JavaAgent;
import com.rookout.rook.RookOptions;
import com.rookout.rook.Singleton;
import com.rookout.rook.Utils;
import java.util.HashMap;
import java.util.Map;
import rook.org.json.JSONObject;

public class Main {
    public static void main(String[] args) {
        String pid;
        boolean verbose = false;
        if (args.length > 0 && args[0].equals("-v")) {
            verbose = true;
        }
        if ((pid = Utils.GetConfigurationString("ROOKOUT_TARGET_PID")) != null) {
            Main.InjectAgentToAnotherJvmProcess(pid, verbose);
            return;
        }
        Main.TestConnectivity(verbose, true);
    }

    private static boolean TestConnectivity(boolean verbose, boolean exit) {
        System.out.println("[Rookout] Testing connection to controller");
        System.out.println("[Rookout] Rookout version: " + Config.Instance().VersionConfiguration$VERSION);
        boolean success = false;
        try {
            Main.CheckJavaAgentPresent();
            RookOptions opts = new RookOptions();
            opts.reload_classes = false;
            opts.disable_class_transform = false;
            opts.throw_errors = true;
            opts.debug = verbose;
            Config.Instance().AgentCom$CONNECTION_TIMEOUT = 10;
            Config.Instance().AgentCom$TIMEOUT = 10;
            JavaAgent.SetOptions(opts);
            JavaAgent.loadOptions();
            Singleton.init(opts, null);
            Singleton.start();
            success = true;
        }
        catch (Throwable e) {
            System.out.printf("[Rookout] Uncaught exception during test: %s\n", e.toString());
        }
        if (!exit) {
            return success;
        }
        if (success) {
            System.out.println("[Rookout] Test finished successfully");
            System.exit(0);
        } else {
            System.out.println("[Rookout] Test failed");
            System.exit(1);
        }
        return success;
    }

    private static void CheckJavaAgentPresent() {
        String rookPresent = System.getProperty("com.rookout.rook.present");
        if (rookPresent != null && rookPresent.equals("TRUE")) {
            System.out.println("[Rookout] Test Canceled - the test cannot be executed with Rookout loaded, please remove \"-javaagent\" from command line and JAVA_TOOL_OPTIONS and try again.");
            System.exit(1);
        }
    }

    private static void InjectAgentToAnotherJvmProcess(String pid, boolean verbose) {
        if (null == Utils.GetConfigurationString("ROOKOUT_SKIP_CONNECTION_CHECK")) {
            Main.TestConnection(verbose);
        }
        System.out.println("[Rookout] Injecting Java Agent to process id - " + pid);
        try {
            APILoader.Load(pid, Main.getOptions());
            System.out.println("[Rookout] Injected successfully");
        }
        catch (Throwable e) {
            System.err.println("[Rookout] Failed to load Java Agent - " + e);
            e.printStackTrace();
        }
    }

    private static String getOptions() {
        HashMap<String, String> allRookoutEnv = new HashMap<String, String>();
        Map<String, String> allEnv = System.getenv();
        for (Map.Entry<String, String> e : allEnv.entrySet()) {
            if (!e.getKey().startsWith("ROOKOUT_")) continue;
            allRookoutEnv.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!entry.getKey().toString().startsWith("ROOKOUT_") || allRookoutEnv.containsKey(entry.getKey().toString())) continue;
            allRookoutEnv.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new JSONObject(allRookoutEnv).toString();
    }

    private static void TestConnection(boolean verbose) {
        int i;
        for (i = 0; i < 5; ++i) {
            if (!Main.TestConnectivity(verbose, false)) continue;
            return;
        }
        if (i == 5) {
            System.out.println("[Rookout] Could not connect to controller - please verify your parameters");
            System.exit(2);
        }
    }
}

