/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import java.util.Iterator;
import java.util.List;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.LocalVariableNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.VarInsnNode;

public class VisitorUtils {
    private static boolean isCtor(String name) {
        return name.equals("<init>");
    }

    public static void LoadArguments(LocalVariableInfo[] variables, String name, String desc, int access) {
        Type[] argumentsTypes;
        int argumentIndex = 0;
        if ((access & 8) == 0) {
            variables[argumentIndex].isStore = !VisitorUtils.isCtor(name);
            ++argumentIndex;
        }
        for (Type argumentsType : argumentsTypes = Type.getArgumentTypes(desc)) {
            variables[argumentIndex].isStore = true;
            String descriptor = argumentsType.getDescriptor();
            if (descriptor.equals("D") || descriptor.equals("J")) {
                argumentIndex += 2;
                continue;
            }
            ++argumentIndex;
        }
    }

    public static void ParseVariblesFromNodes(AbstractInsnNode insnIterator, LocalVariableInfo[] variables, List<LocalVariableNode> localVariables, String name, Type superType) {
        if (insnIterator.getType() == 8) {
            Iterator<LocalVariableNode> iterator = localVariables.iterator();
            while (iterator.hasNext()) {
                LocalVariableNode iterator2;
                LocalVariableNode localVariableNode = iterator2 = iterator.next();
                if (localVariableNode.start == insnIterator) {
                    variables[localVariableNode.index].inScope = true;
                    variables[localVariableNode.index].name = localVariableNode.name;
                    variables[localVariableNode.index].desc = localVariableNode.desc;
                    continue;
                }
                if (localVariableNode.end != insnIterator) continue;
                variables[localVariableNode.index].inScope = false;
                variables[localVariableNode.index].isStore = false;
                variables[localVariableNode.index].name = null;
                variables[localVariableNode.index].desc = null;
            }
        } else if (insnIterator.getType() == 2) {
            VarInsnNode varInsnNode = (VarInsnNode)insnIterator;
            if (varInsnNode.getOpcode() == 54 || varInsnNode.getOpcode() == 56 || varInsnNode.getOpcode() == 58) {
                variables[varInsnNode.var].isStore = true;
            } else if (varInsnNode.getOpcode() == 57 || varInsnNode.getOpcode() == 55) {
                variables[varInsnNode.var].isStore = true;
                variables[varInsnNode.var + 1].isStore = false;
            }
        } else if (insnIterator.getOpcode() == 183 && VisitorUtils.isCtor(name) && !variables[0].isStore) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnIterator;
            if (methodInsnNode.name.equals("<init>") && methodInsnNode.owner.equals(superType.getInternalName())) {
                AbstractInsnNode maybeFirstArgument = methodInsnNode.getPrevious();
                for (int i = 1; i < Type.getArgumentTypes(methodInsnNode.desc).length; ++i) {
                    if (null == maybeFirstArgument) continue;
                    maybeFirstArgument = maybeFirstArgument.getPrevious();
                }
                if (null == maybeFirstArgument || maybeFirstArgument.getOpcode() != 25) {
                    return;
                }
                VarInsnNode varInsnNode = (VarInsnNode)maybeFirstArgument;
                if (varInsnNode.var == 0) {
                    variables[0].isStore = true;
                }
            }
        }
    }
}

