/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import com.rookout.rook.Services.Instrumentation.LocalsParserVisitor;
import com.rookout.rook.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassWriter;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.LdcInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.LocalVariableNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.VarInsnNode;

public class VisitorUtils {
    private static boolean isCtor(String name) {
        return name.equals("<init>");
    }

    public static void LoadArguments(LocalVariableInfo[] variables, String name, String desc, int access) {
        Type[] argumentsTypes;
        int argumentIndex = 0;
        if ((access & 8) == 0) {
            variables[argumentIndex].isStore = !VisitorUtils.isCtor(name);
            ++argumentIndex;
        }
        for (Type argumentsType : argumentsTypes = Type.getArgumentTypes(desc)) {
            variables[argumentIndex].isStore = true;
            String descriptor = argumentsType.getDescriptor();
            if (descriptor.equals("D") || descriptor.equals("J")) {
                argumentIndex += 2;
                continue;
            }
            ++argumentIndex;
        }
    }

    public static void ParseVariblesFromNodes(AbstractInsnNode insnIterator, LocalVariableInfo[] variables, List<LocalVariableNode> localVariables, String name, Type superType) {
        if (insnIterator.getType() == 8) {
            Iterator<LocalVariableNode> iterator = localVariables.iterator();
            while (iterator.hasNext()) {
                LocalVariableNode iterator2;
                LocalVariableNode localVariableNode = iterator2 = iterator.next();
                if (localVariableNode.start == insnIterator) {
                    variables[localVariableNode.index].inScope = true;
                    variables[localVariableNode.index].name = localVariableNode.name;
                    variables[localVariableNode.index].desc = localVariableNode.desc;
                    continue;
                }
                if (localVariableNode.end != insnIterator) continue;
                variables[localVariableNode.index].inScope = false;
                variables[localVariableNode.index].isStore = false;
                variables[localVariableNode.index].name = null;
                variables[localVariableNode.index].desc = null;
            }
        } else if (insnIterator.getType() == 2) {
            VarInsnNode varInsnNode = (VarInsnNode)insnIterator;
            if (varInsnNode.getOpcode() == 54 || varInsnNode.getOpcode() == 56 || varInsnNode.getOpcode() == 58) {
                variables[varInsnNode.var].isStore = true;
            } else if (varInsnNode.getOpcode() == 57 || varInsnNode.getOpcode() == 55) {
                variables[varInsnNode.var].isStore = true;
                variables[varInsnNode.var + 1].isStore = false;
            }
        } else if (insnIterator.getOpcode() == 183 && VisitorUtils.isCtor(name) && !variables[0].isStore) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnIterator;
            if (methodInsnNode.name.equals("<init>") && methodInsnNode.owner.equals(superType.getInternalName())) {
                AbstractInsnNode maybeFirstArgument = methodInsnNode.getPrevious();
                for (int i = 1; i < Type.getArgumentTypes(methodInsnNode.desc).length; ++i) {
                    if (null == maybeFirstArgument) continue;
                    maybeFirstArgument = maybeFirstArgument.getPrevious();
                }
                if (null == maybeFirstArgument || maybeFirstArgument.getOpcode() != 25) {
                    return;
                }
                VarInsnNode varInsnNode = (VarInsnNode)maybeFirstArgument;
                if (varInsnNode.var == 0) {
                    variables[0].isStore = true;
                }
            }
        }
    }

    private static InsnList PrimitiveToObject(int index, Type primitiveType, Class classType, int loadOpcode) {
        InsnList converter = new InsnList();
        converter.add(new VarInsnNode(loadOpcode, index));
        converter.add(new MethodInsnNode(184, Type.getInternalName(classType), "valueOf", Type.getMethodDescriptor(Type.getType(classType), primitiveType), false));
        return converter;
    }

    private static InsnList GetValue(String desc, int index) {
        switch (desc) {
            case "B": {
                return VisitorUtils.PrimitiveToObject(index, Type.BYTE_TYPE, Byte.class, 21);
            }
            case "C": {
                return VisitorUtils.PrimitiveToObject(index, Type.CHAR_TYPE, Character.class, 21);
            }
            case "D": {
                return VisitorUtils.PrimitiveToObject(index, Type.DOUBLE_TYPE, Double.class, 24);
            }
            case "F": {
                return VisitorUtils.PrimitiveToObject(index, Type.FLOAT_TYPE, Float.class, 23);
            }
            case "I": {
                return VisitorUtils.PrimitiveToObject(index, Type.INT_TYPE, Integer.class, 21);
            }
            case "J": {
                return VisitorUtils.PrimitiveToObject(index, Type.LONG_TYPE, Long.class, 22);
            }
            case "S": {
                return VisitorUtils.PrimitiveToObject(index, Type.SHORT_TYPE, Short.class, 21);
            }
            case "Z": {
                return VisitorUtils.PrimitiveToObject(index, Type.BOOLEAN_TYPE, Boolean.class, 21);
            }
        }
        InsnList valueGetter = new InsnList();
        if (desc.startsWith("L") || desc.startsWith("[")) {
            valueGetter.add(new VarInsnNode(25, index));
        } else {
            RookLogger.Instance().warn("Unknown variable desc: " + desc, new Object[0]);
            valueGetter.add(new LdcInsnNode("Rookout: Unsupported Primitive Type: " + desc));
        }
        return valueGetter;
    }

    public static int ParseVariables(LocalVariableInfo[] variables, InsnList hook, boolean isCfm) {
        int localsCount = 0;
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].inScope || !variables[i].isStore || isCfm && !variables[i].desc.equals("Lcoldfusion/runtime/Variable;") && !variables[i].name.equals("this")) continue;
            ++localsCount;
            hook.add(new InsnNode(89));
            hook.add(new LdcInsnNode(variables[i].name));
            hook.add(VisitorUtils.GetValue(variables[i].desc, i));
            hook.add(new MethodInsnNode(182, Type.getInternalName(HashMap.class), "put", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)), false));
            hook.add(new InsnNode(87));
        }
        return localsCount;
    }

    private static boolean ParseEntry(byte[] classBuffer, String fileName, InsnList hook, LineNumberNode hookNode, String className, String name, String desc, boolean isCfm) {
        if (fileName.contains(className) && fileName.endsWith(".class")) {
            try {
                RookLogger.Instance().debug("Found class: " + fileName, new Object[0]);
                ClassReader reader = new ClassReader(classBuffer);
                ClassWriter writer = new ClassWriter(reader, 0);
                LocalsParserVisitor visitor = new LocalsParserVisitor(writer, hookNode, name, desc);
                try {
                    reader.accept(visitor, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (visitor.DidFindLine()) {
                    RookLogger.Instance().debug("Locals found", new Object[0]);
                    VisitorUtils.ParseVariables(visitor.GetLocalVariables(), hook, isCfm);
                    return true;
                }
                RookLogger.Instance().log(Level.SEVERE, "Could not locate locals");
            }
            catch (Exception e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to parse locals: " + e.toString());
            }
        }
        return false;
    }

    private static boolean ParseInnerJar(JarFile jf, JarEntry entry, InsnList hook, LineNumberNode hookNode, String className, String name, String desc, boolean isCfm) {
        try {
            InputStream inputStream = jf.getInputStream(entry);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                int len;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((len = jarInputStream.read(buffer)) > 0) {
                    output.write(buffer, 0, len);
                }
                if (VisitorUtils.ParseEntry(output.toByteArray(), jarEntry.getName(), hook, hookNode, className, name, desc, isCfm)) {
                    return true;
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to parse locals in inner jar: " + e.toString(), e, new Object[0]);
        }
        return false;
    }

    private static void ParseFileSystem(Path dir, InsnList hook, LineNumberNode hookNode, String className, String name, String desc, boolean isCfm) {
        ArrayList<String> filePaths = new ArrayList<String>();
        try {
            Utils.GetAllFileInDirectory(filePaths, dir);
            for (String filePath : filePaths) {
                if (!VisitorUtils.ParseEntry(Files.readAllBytes(Paths.get(filePath, new String[0])), filePath, hook, hookNode, className, name, desc, isCfm)) continue;
                return;
            }
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to parse locals in file system: " + e.toString(), e, new Object[0]);
        }
    }

    public static void ParseLocalVariablesFromDisk(URL sourceLocation, InsnList hook, LineNumberNode hookNode, String className, String name, String desc, boolean isCfm) {
        try {
            String path = sourceLocation.getPath().toLowerCase();
            RookLogger.Instance().debug("Reading class from: " + path, new Object[0]);
            if (path.endsWith(".jar") || path.endsWith(".ear") || path.endsWith(".war")) {
                JarFile jarFile = new JarFile(sourceLocation.getPath());
                Enumeration<JarEntry> elements = jarFile.entries();
                while (elements.hasMoreElements()) {
                    JarEntry entry = elements.nextElement();
                    if (entry.getName().toLowerCase().endsWith(".jar") || entry.getName().toLowerCase().endsWith(".war")) {
                        RookLogger.Instance().debug("Parsing inner jar: " + entry.getName(), new Object[0]);
                        if (VisitorUtils.ParseInnerJar(jarFile, entry, hook, hookNode, className, name, desc, isCfm)) {
                            return;
                        }
                    }
                    if (!VisitorUtils.ParseEntry(Utils.getEntryBytes(jarFile, entry), entry.getName(), hook, hookNode, className, name, desc, isCfm)) continue;
                    return;
                }
            } else {
                RookLogger.Instance().debug("Parsing directory: " + sourceLocation.getPath(), new Object[0]);
                VisitorUtils.ParseFileSystem(Paths.get(sourceLocation.getPath(), new String[0]), hook, hookNode, className, name, desc, isCfm);
            }
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to parse locals: " + e.toString());
        }
    }
}

