/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.AugManager;
import com.rookout.rook.ComWs.AgentComWs;
import com.rookout.rook.ComWs.CommandHandler;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.DebugSignalHandler;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.RookOptions;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.Services.Monitor.MonitorService;
import com.rookout.rook.TriggerServices;
import java.lang.instrument.Instrumentation;
import java.util.logging.Level;

public class Singleton {
    private static Singleton instance;
    private OutputWs output = new OutputWs();
    private boolean servicesStarted = false;
    private TriggerServices triggerServices = null;
    private AugManager augManager = null;
    private AgentComWs agentCom = null;
    private CommandHandler commandHandler;
    private RookOptions opts;

    static void init(RookOptions opts, Instrumentation instrumentation) {
        InstrumentationService.SetInstrumentation(instrumentation, opts.reload_classes, opts.disable_class_transform);
        Singleton.Instance().opts = opts;
        if (opts.debug.booleanValue()) {
            DebugSignalHandler.SetInstrumentation(instrumentation);
            DebugSignalHandler.listenTo("CONT");
            DebugSignalHandler.listenTo("SIGCONT");
        }
    }

    public static void start() throws Exception {
        block26: {
            Singleton s = Singleton.Instance();
            if (s.servicesStarted) {
                return;
            }
            RookOptions opts = s.opts;
            if (opts.debug.booleanValue()) {
                System.out.println(opts.toString());
            }
            try {
                try {
                    if (opts.token == null && opts.host == null) {
                        throw new Exceptions.RookMissingToken();
                    }
                    if (opts.token != null) {
                        Singleton.validateToken(opts.token);
                    }
                    Config config = Config.Instance();
                    if (opts.host == null) {
                        opts.host = config.ControllerAddress$HOST;
                    }
                    if (opts.host.equals("staging.cloud.agent.rookout.com") || opts.host.equals("cloud.agent.rookout.com")) {
                        opts.host = "https://" + opts.host;
                    }
                    if (opts.host.equals("staging.control.rookout.com") || opts.host.equals("control.rookout.com")) {
                        opts.host = "wss://" + opts.host;
                    }
                    if (opts.log_file != null) {
                        config.LoggingConfiguration$FILE_NAME = opts.log_file;
                    }
                    if (opts.log_level != null) {
                        config.LoggingConfiguration$LOG_LEVEL = opts.log_level;
                    }
                    if (opts.log_to_stderr != null) {
                        config.LoggingConfiguration$LOG_TO_STDERR = opts.log_to_stderr;
                    }
                    if (opts.debug != null && opts.debug.booleanValue()) {
                        config.LoggingConfiguration$LOG_LEVEL = "DEBUG";
                        config.LoggingConfiguration$LOG_TO_STDERR = true;
                        config.LoggingConfiguration$DEBUG = true;
                    }
                    if (opts.port == null) {
                        opts.port = config.ControllerAddress$PORT;
                    }
                    for (String key : opts.labels.keySet()) {
                        Singleton.validateLabel(key);
                    }
                    if (opts.git_commit != null) {
                        config.GitConfiguration$COMMIT = opts.git_commit;
                    }
                    if (opts.git_origin != null) {
                        config.GitConfiguration$ORIGIN = opts.git_origin;
                    }
                    if (opts.enableMonitor == null) {
                        opts.enableMonitor = config.MonitorConfiguration$ENABLED;
                    }
                    RookLogger.Instance().debug("Rookout SDK for JVM, Version:" + config.VersionConfiguration$VERSION + " Commit:" + config.VersionConfiguration$COMMIT, new Object[0]);
                    RookLogger.Instance().debug("JVM Version: %s, JVM Vendor: %s", System.getProperty("java.version"), System.getProperty("java.vm.vendor"));
                    s.output = new OutputWs();
                    Singleton.Instance().Connect();
                }
                catch (Exceptions.RookUnSupportedEnvironment e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Unsupported JVM. Rookout supports Java 7, 8, 9, 10, 11, 12 and 13 on Oracle Java, Oracle OpenJDK or AdoptOpenJDK");
                        System.err.println("[Rookout] " + e.getMessage());
                        System.err.println("[Rookout] For further information visit: https://docs.rookout.com/docs/sdk-setup.html#supported-versions-1");
                    }
                    throw e;
                }
                catch (Exceptions.RookInvalidLabel | Exceptions.RookInvalidOptions | Exceptions.RookInvalidToken | Exceptions.RookMissingToken e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Failed to start Rookout: " + e.getMessage());
                    }
                    throw e;
                }
                catch (Throwable e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Failed to connect to the controller - will continue attempting in the background: " + e.getMessage());
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                if (s.opts.debug.booleanValue()) {
                    e.printStackTrace();
                }
                if (!s.opts.throw_errors.booleanValue()) break block26;
                throw e;
            }
        }
    }

    public static void stop() {
        block3: {
            Singleton s = Singleton.Instance();
            try {
                s.Close();
            }
            catch (Exception e) {
                if (s.opts.debug.booleanValue()) {
                    e.printStackTrace();
                }
                if (!s.opts.throw_errors.booleanValue()) break block3;
                throw e;
            }
        }
    }

    public static Singleton Instance() {
        if (null == instance) {
            instance = new Singleton();
        }
        return instance;
    }

    private Singleton() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RookLogger.Instance().log(Level.INFO, "Exit handler called - closing");
                    Singleton.this.Close();
                }
                catch (Throwable t) {
                    RookLogger.Instance().log(Level.WARNING, "Close failed", t, new Object[0]);
                }
                RookLogger.Instance().log(Level.INFO, "Exit handler finished");
            }
        }));
    }

    public void StartServices() {
        if (this.servicesStarted) {
            return;
        }
        this.triggerServices = new TriggerServices();
        this.augManager = new AugManager(this.triggerServices, this.output);
        this.servicesStarted = true;
        if (this.opts.enableMonitor.booleanValue()) {
            MonitorService.Start();
        }
    }

    public void StopServices() {
        if (!this.servicesStarted) {
            return;
        }
        this.augManager = null;
        this.triggerServices.Close();
        this.triggerServices = null;
        this.servicesStarted = false;
        MonitorService.Stop();
        RookLogger.Close();
    }

    void Connect() throws Exception {
        this.StartServices();
        RookLogger.Instance().info("Connecting to controller", new Object[0]);
        this.output.setTags(this.opts.tags, this.opts.labels);
        this.agentCom = new AgentComWs(this.output, this.opts.host, this.opts.port, this.opts.proxy, this.opts.token, this.opts.labels, this.opts.tags);
        this.commandHandler = new CommandHandler(this.agentCom, this.augManager);
        this.output.setAgentCom(this.agentCom);
        this.agentCom.ConnectToAgent();
    }

    void Close() {
        RookLogger.Instance().info("Shutting down", new Object[0]);
        if (null != this.agentCom) {
            this.agentCom.Close();
        }
        this.StopServices();
    }

    public void Flush() {
        if (null != this.output && null != this.agentCom) {
            this.output.FlushMessages();
        }
    }

    public TriggerServices getTriggerServices() {
        return this.triggerServices;
    }

    public static void validateToken(String token) throws Exceptions.RookInvalidOptions {
        if (token.length() != 64) {
            throw new Exceptions.RookInvalidOptions("Rookout token should be 64 characters");
        }
        if (!token.matches("^[0-9a-zA-Z]+$")) {
            throw new Exceptions.RookInvalidOptions("Rookout token must consist of only hexadecimal characters");
        }
    }

    public static void validateLabel(String label) throws Exceptions.RookInvalidLabel {
        if (label.startsWith("$")) {
            throw new Exceptions.RookInvalidLabel(label);
        }
    }
}

