/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Instrumentation.Augs;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.objectweb.asm.Type;

public class CallbackDispatcher {
    private static CallbackDispatcher instance;
    private final Augs augs;
    static final String CallbackDescriptor;

    static void CreateCallbackDispatcher(Augs augs) {
        if (null != instance) {
            throw new RuntimeException("Cannot create CallbackDispatcher twice");
        }
        instance = new CallbackDispatcher(augs);
    }

    static void Close() {
        instance = null;
    }

    public void Callback(String fileName, int lineno, HashMap<String, Object> locals, Throwable t) throws Throwable {
        try {
            long now = System.currentTimeMillis();
            Augs.AugsSet augsSet = this.augs.GetAppliedAugs(fileName, lineno);
            if (null != augsSet) {
                Frame frame = new Frame(t, locals);
                frame.stackTrace.setBaseFrameIndex(1);
                for (Aug aug : augsSet) {
                    aug.Execute(frame, null, now);
                }
            } else {
                RookLogger.Instance().fatal("Failed to find aug for id: " + fileName + "@" + lineno, new Object[0]);
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    private CallbackDispatcher(Augs augs) {
        this.augs = augs;
    }

    static {
        CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.INT_TYPE, Type.getType(HashMap.class));
    }
}

