/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import java.io.InputStream;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.Label;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.tree.MethodNode;

public class VisitorFindLocation
extends ClassVisitor {
    private final LocationFileLine location;
    private final String className;
    private final ClassLoader classLoader;
    private int updatedLineNo = 0;
    private boolean lineFound = false;
    private boolean safeToSkip = false;

    VisitorFindLocation(LocationFileLine location, String className, ClassLoader classLoader) {
        super(458752);
        this.location = location;
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (HashCheck.shouldValidateHash(this.location)) {
            this.updatedLineNo = HashCheck.GetUpdatedLineNumber(this.location, this.className, this.classLoader);
            if (-1 == this.updatedLineNo) {
                // empty if block
            }
        } else {
            this.updatedLineNo = this.location.getLineno();
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitLineNumber(int line, Label start) {
                if (line == VisitorFindLocation.this.updatedLineNo) {
                    VisitorFindLocation.this.lineFound = true;
                }
                super.visitLineNumber(line, start);
            }
        };
    }

    @Override
    public void visitEnd() {
        if (!this.lineFound) {
            this.safeToSkip = true;
        }
        super.visitEnd();
    }

    static boolean IsSafeToSkipClass(InputStream classAsStream, LocationFileLine location, String className, ClassLoader classLoader) {
        VisitorFindLocation visitor = new VisitorFindLocation(location, className, classLoader);
        try {
            ClassReader reader = new ClassReader(classAsStream);
            reader.accept(visitor, 0);
        }
        catch (Throwable e) {
            return false;
        }
        return visitor.safeToSkip;
    }
}

