/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

class HashCheck {
    HashCheck() {
    }

    static FileHashes getFileHashes(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        String fileContents = new String(buffer).replace("\r\n", "\n").replace("\r\u0000\n\u0000", "\n\u0000").replace("\r", "\n");
        CRC32 checksum = new CRC32();
        String[] lines = fileContents.split("\n");
        Long[] linesHashes = new Long[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            checksum.update(lines[i].getBytes(), 0, lines[i].length());
            linesHashes[i] = checksum.getValue() & 0xFFFFFFFFFFFFFFFFL;
            checksum.reset();
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContents.getBytes("UTF-8"));
        return new FileHashes(Utils.bytesToHex(hash), linesHashes);
    }

    static FileHashes getFileHashes(InputStream fileContents) throws NoSuchAlgorithmException, IOException {
        byte[] rawBuffer = new byte[fileContents.available()];
        fileContents.read(rawBuffer);
        return HashCheck.getFileHashes(rawBuffer);
    }

    static int findLineUsingCrc(LocationFileLine location, FileHashes fileHashes) {
        Long actualCrc = 0L;
        HashInfo hashInfo = location.getHashInfo();
        if (location.getLineno() > 0 && location.getLineno() <= fileHashes.lines_crcs.length) {
            actualCrc = fileHashes.lines_crcs[location.getLineno() - 1];
        }
        if (fileHashes.lines_crcs.length >= location.getLineno() && hashInfo.line_crc.equals(actualCrc)) {
            return location.getLineno();
        }
        if (!hashInfo.line_crc_unique.booleanValue()) {
            location.SetError(new RookError(new Exceptions.RookCrcMismatchException(location.getFilename(), hashInfo.line_crc, actualCrc)));
            return -1;
        }
        int firstIndex = -1;
        boolean secondFound = false;
        for (int i = 0; i < fileHashes.lines_crcs.length; ++i) {
            if (!fileHashes.lines_crcs[i].equals(hashInfo.line_crc)) continue;
            if (firstIndex == -1) {
                firstIndex = i;
                continue;
            }
            secondFound = true;
            break;
        }
        if (firstIndex != -1 && !secondFound) {
            int updatedLine = firstIndex + 1;
            location.SendWarning(new RookError(new Exceptions.RookLineMoved(location.getFilename(), location.getLineno(), updatedLine)));
            return updatedLine;
        }
        location.SetError(new RookError(new Exceptions.RookCrcMismatchException(location.getFilename(), hashInfo.line_crc, actualCrc)));
        return -1;
    }

    static boolean shouldValidateHash(LocationFileLine location) {
        HashInfo hashInfo = location.getHashInfo();
        if (hashInfo == null) {
            return false;
        }
        return hashInfo.file_hash != null || hashInfo.line_crc != null;
    }

    static int GetUpdatedLineNumber(LocationFileLine location, String className, ClassLoader classLoader) {
        String sourceFileName;
        InputStream fileContents;
        if (-1 != className.indexOf(36)) {
            className = className.substring(0, className.indexOf(36));
        }
        if (null == (fileContents = classLoader.getResourceAsStream(sourceFileName = className + location.getFileExtension()))) {
            location.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(sourceFileName)));
            return location.getLineno();
        }
        FileHashes hashes = null;
        try {
            hashes = HashCheck.getFileHashes(fileContents);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            location.SendWarning(new RookError(new Exceptions.RookHashCalculationFailed(sourceFileName, className, (Throwable)e)));
            return location.getLineno();
        }
        HashInfo hashInfo = location.getHashInfo();
        if (hashInfo.line_crc != null) {
            return HashCheck.findLineUsingCrc(location, hashes);
        }
        if (hashes.file_hash.equals(hashInfo.file_hash)) {
            return location.getLineno();
        }
        location.SetError(new RookError(new Exceptions.RookHashMismatchException(location.getFilename(), hashInfo.file_hash, hashes.file_hash)));
        return -1;
    }

    public static class FileHashes {
        public String file_hash;
        public Long[] lines_crcs;

        public FileHashes(String file_hash, Long[] lines_crcs) {
            this.file_hash = file_hash;
            this.lines_crcs = lines_crcs;
        }
    }
}

