/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.IClassReloader;
import com.rookout.rook.Services.Instrumentation.VisitorFindLocation;
import com.rookout.rook.Services.StackTrace.StackWalkerLock;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;

public class ClassReloader
implements IClassReloader {
    private final long sleepInterval;
    private final long shortSleepInterval;
    private Thread thread;
    private boolean closing = false;
    private final Instrumentation inst;
    private final Augs augs;
    private final Files files;
    private Queue queue;

    ClassReloader(Instrumentation inst, Augs augs, Files files) {
        this.inst = inst;
        this.augs = augs;
        this.files = files;
        this.sleepInterval = Config.Instance().ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS.intValue();
        this.shortSleepInterval = this.sleepInterval / 25L;
        if (this.sleepInterval > 0L) {
            this.queue = new Queue();
            this.thread = new Thread((Runnable)new WorkerRunnable(), Config.Instance().ClassReloaderConfiguration$THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void Stop() {
        this.closing = true;
        if (null != this.queue) {
            this.queue.Stop();
        }
        try {
            if (null != this.thread) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (InterruptedException e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e, new Object[0]);
        }
        this.queue = null;
    }

    @Override
    public void AddAug(LocationFileLine location) {
        this.augs.AddAug(location);
        location.SetPending();
        this.InstructReload(new augContext(location, true));
    }

    @Override
    public void RemoveAug(String augId) {
        LocationFileLine location = this.augs.GetAugById(augId);
        if (null == location) {
            return;
        }
        location.MarkDeleted();
        this.InstructReload(new augContext(location, false));
    }

    private void InstructReload(augContext context) {
        if (this.sleepInterval > 0L && !this.closing) {
            this.queue.Insert(context);
            return;
        }
        this.ApplyAugAndReloadClass(context);
    }

    private void ApplyAugAndReloadClass(augContext context) {
        String fileName = context.location.getFilename();
        if (this.files.IsLoaded(fileName)) {
            Files.ClassSet classes = this.files.GetClasses(fileName);
            HashSet<Files.ClassObject> filteredClasses = this.GetAllClassesToRetransform(classes, context.location);
            if (filteredClasses.size() > Config.Instance().ClassReloaderConfiguration$MAX_CLASS_COUNT_FOR_LOCATION) {
                context.location.SendError(new RookError(new Exceptions.RookTooManyClassesForLocation()));
                return;
            }
            for (Files.ClassObject cls : filteredClasses) {
                this.ReloadClass(context.location, cls);
            }
        }
        if (!context.addAction.booleanValue()) {
            this.augs.RemoveAug(context.location.getAugId());
            context.location.SetRemoved();
        }
    }

    private HashSet<Files.ClassObject> GetAllClassesToRetransform(Files.ClassSet classes, LocationFileLine location) {
        HashSet<Files.ClassObject> filteredClasses = new HashSet<Files.ClassObject>();
        for (Files.ClassObject cls : classes) {
            URL rawClass = cls.classLoader.getResource(cls.getClassName() + ".class");
            if (null != rawClass && VisitorFindLocation.IsSafeToSkipClass(rawClass, location, cls.getClassName(), cls.classLoader)) {
                try {
                    Thread.sleep(this.shortSleepInterval);
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while sleeping", e, new Object[0]);
                }
                continue;
            }
            filteredClasses.add(cls);
        }
        return filteredClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReloadClass(LocationFileLine location, Files.ClassObject classObject) {
        Class<?> cls;
        String javaName = classObject.getClassName().replace("/", ".");
        try {
            cls = Class.forName(javaName, true, classObject.classLoader);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (Error e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to get class", e, new Object[0]);
            return;
        }
        if (!this.inst.isModifiableClass(cls)) {
            return;
        }
        try {
            RookLogger.Instance().info("Retransforming class: " + javaName, new Object[0]);
            StackWalkerLock.lock.writeLock().lock();
            this.inst.retransformClasses(cls);
        }
        catch (Throwable e) {
            String message = "Error while reloading file";
            RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            location.SendError(new RookError(e, message));
        }
        finally {
            StackWalkerLock.lock.writeLock().unlock();
        }
        try {
            Thread.sleep(this.sleepInterval);
        }
        catch (InterruptedException e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while sleeping", e, new Object[0]);
        }
    }

    private class augContext {
        LocationFileLine location;
        Boolean addAction;

        augContext(LocationFileLine location, Boolean addAction) {
            this.location = location;
            this.addAction = addAction;
        }
    }

    private class Queue {
        boolean closing = false;
        LinkedHashSet augContextSet = new LinkedHashSet();

        Queue() {
        }

        synchronized void Stop() {
            this.closing = true;
            this.notify();
        }

        synchronized void Insert(augContext item) {
            this.augContextSet.add(item);
            if (1 <= this.augContextSet.size()) {
                this.notify();
            }
        }

        synchronized augContext Pop() {
            while (this.IsEmpty() && !this.closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while waiting", e, new Object[0]);
                }
            }
            if (this.closing) {
                return null;
            }
            Iterator i = this.augContextSet.iterator();
            augContext next = (augContext)i.next();
            i.remove();
            return next;
        }

        synchronized boolean IsEmpty() {
            return this.augContextSet.size() == 0;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            while (!ClassReloader.this.closing) {
                augContext context = ClassReloader.this.queue.Pop();
                if (null == context) {
                    return;
                }
                ClassReloader.this.ApplyAugAndReloadClass(context);
            }
        }
    }
}

