/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import java.util.logging.Level;

public class TriggerServices {
    private InstrumentationService instrumentation;

    public TriggerServices() {
        try {
            this.instrumentation = InstrumentationService.Build();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Error in initiating InstrumentationService", e, new Object[0]);
        }
    }

    public InstrumentationService getInstrumentation() throws Exception {
        if (null != this.instrumentation) {
            return this.instrumentation;
        }
        throw new Exceptions.RookInstrumentationUnavailable();
    }

    public void RemoveAug(String augId) {
        if (null != this.instrumentation) {
            this.instrumentation.RemoveAug(augId);
        }
    }

    public void ClearAugs() {
        if (null != this.instrumentation) {
            this.instrumentation.ClearAugs();
        }
    }

    public void Close() {
        this.ClearAugs();
        if (null != this.instrumentation) {
            this.instrumentation.Close();
        }
    }
}

