/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.UserWarnings;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class AugRateLimiter {
    private final long windowSize;
    private final long quota;
    private final long activeWeight;
    private int activeCount = 0;
    private boolean sendWarning = true;
    private final Map<Long, Long> windows = new LinkedHashMap<Long, Long>();
    private static final long MIN_RATE_LIMIT_VALUE = 5L;

    AugRateLimiter(long quota, long windowSize, int activeLimit) {
        this.quota = quota;
        this.windowSize = windowSize > 0L ? windowSize : 1L;
        this.activeWeight = 0 != activeLimit ? quota / (long)activeLimit : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TryWithRateLimit(long startTime, Runnable augCore) {
        Long current_window_key = AugRateLimiter.floorDiv(startTime, this.windowSize) * this.windowSize;
        Long prev_window_key = current_window_key - this.windowSize;
        boolean rateLimited = false;
        AugRateLimiter augRateLimiter = this;
        synchronized (augRateLimiter) {
            this.cleanup(startTime);
            ++this.activeCount;
            if (this.quota > 0L && this.currentUsage(startTime, current_window_key, prev_window_key) > this.quota) {
                --this.activeCount;
                rateLimited = true;
            }
        }
        if (rateLimited) {
            if (this.sendWarning) {
                UserWarnings.SendWarning(new RookError(new Exceptions.RookRuleRateLimited()));
                this.sendWarning = false;
            }
            return;
        }
        try {
            augCore.run();
        }
        finally {
            long duration = Math.max(System.currentTimeMillis() - startTime, 5L);
            AugRateLimiter augRateLimiter2 = this;
            synchronized (augRateLimiter2) {
                --this.activeCount;
                this.RecordUsage(current_window_key, duration);
            }
        }
    }

    private void RecordUsage(long current_window_key, long duration) {
        Long total_usage = this.windows.get(current_window_key);
        if (total_usage != null) {
            this.windows.put(current_window_key, total_usage + duration);
        }
    }

    private long currentUsage(Long startTime, Long currentWindowKey, Long prevWindowKey) {
        Long prev_window_usage;
        Long current_window_usage = this.windows.get(currentWindowKey);
        if (current_window_usage == null) {
            this.windows.put(currentWindowKey, 0L);
            current_window_usage = 0L;
        }
        if (null == (prev_window_usage = this.windows.get(prevWindowKey))) {
            prev_window_usage = 0L;
        }
        float prevWeight = 1.0f - (float)(startTime - currentWindowKey) / (float)this.windowSize;
        return (long)((float)prev_window_usage.longValue() * prevWeight) + (long)this.activeCount * this.activeWeight + current_window_usage;
    }

    private void cleanup(long startTime) {
        if (this.windows.size() > 10) {
            Iterator<Map.Entry<Long, Long>> it = this.windows.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Long> entry = it.next();
                Long key = entry.getKey();
                if (key >= startTime - this.windowSize * 5L) continue;
                it.remove();
            }
        }
    }

    private static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }
}

