/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.RookLogger;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;

public class OpentraceNamespace
extends Namespace {
    private HashMap<String, Object> locals;

    public OpentraceNamespace(HashMap<String, Object> locals) {
        this.locals = locals;
    }

    private ContainerNamespace GetDump() throws Exceptions.ToolException {
        ContainerNamespace containerNamespace = new ContainerNamespace();
        containerNamespace.WriteAttribute("span", this.ReadAttribute("span"));
        return containerNamespace;
    }

    private ClassLoader getCallerClassLoader() {
        for (String str : this.locals.keySet()) {
            if (!str.equals("this")) continue;
            return this.locals.get(str).getClass().getClassLoader();
        }
        return null;
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        try {
            Object span;
            Method activeSpan;
            Object globalTracer;
            Method staticGetGlobalTracer;
            Class<?> globalTracerStaticClass;
            ClassLoader cl = this.getCallerClassLoader();
            if (cl != null && (globalTracerStaticClass = cl.loadClass("io.opentracing.util.GlobalTracer")) != null && (staticGetGlobalTracer = globalTracerStaticClass.getMethod("get", new Class[0])) != null && (globalTracer = staticGetGlobalTracer.invoke(null, new Object[0])) != null && (activeSpan = globalTracer.getClass().getMethod("activeSpan", new Class[0])) != null && (span = activeSpan.invoke(globalTracer, new Object[0])) != null && !span.getClass().getName().contains("NoopSpan")) {
                return new JavaObjectNamespace(span, JavaObjectNamespace.ObjectDumpConfig.GetTolerantDumpConfig());
            }
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("OpenTracing Span Not Found : " + t.getMessage(), new Object[0]);
        }
        return this.ReadServlet(name);
    }

    private Namespace ReadServlet(String name) {
        try {
            Object request;
            Method getRequest;
            Object requestAttributes;
            Method getRequestAttributes;
            Class<?> requestContextHolder;
            ClassLoader cl = this.getCallerClassLoader();
            if (cl != null && (requestContextHolder = cl.loadClass("org.springframework.web.context.request.RequestContextHolder")) != null && (getRequestAttributes = requestContextHolder.getMethod("getRequestAttributes", new Class[0])) != null && (requestAttributes = getRequestAttributes.invoke(null, new Object[0])) != null && (getRequest = requestAttributes.getClass().getMethod("getRequest", new Class[0])) != null && (request = getRequest.invoke(requestAttributes, new Object[0])) != null) {
                String spanId;
                Method getMethod = request.getClass().getMethod("getMethod", new Class[0]);
                Method getRequestURI = request.getClass().getMethod("getRequestURI", new Class[0]);
                Method getHeaderNames = request.getClass().getMethod("getHeaderNames", new Class[0]);
                Method getAttributeNames = request.getClass().getMethod("getAttributeNames", new Class[0]);
                Method getRequestURL = request.getClass().getMethod("getRequestURL", new Class[0]);
                Class[] cArg = new Class[]{String.class};
                Method getHeader = request.getClass().getMethod("getHeader", cArg);
                Method getAttribute = request.getClass().getMethod("getAttribute", cArg);
                Class[] cArg2 = new Class[]{String.class, Object.class};
                Method setAttribute = request.getClass().getMethod("setAttribute", cArg2);
                HashMap<String, Object> headers = new HashMap<String, Object>();
                if (getHeaderNames != null) {
                    Enumeration headerNames = (Enumeration)getHeaderNames.invoke(request, new Object[0]);
                    while (headerNames.hasMoreElements()) {
                        String key = (String)headerNames.nextElement();
                        headers.put(key, getHeader.invoke(request, key));
                    }
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (getAttributeNames != null) {
                    Enumeration attributeNames = (Enumeration)getAttributeNames.invoke(request, new Object[0]);
                    while (attributeNames.hasMoreElements()) {
                        String key = (String)attributeNames.nextElement();
                        attributes.put(key, getAttribute.invoke(request, key));
                    }
                }
                if (!attributes.containsKey("spanId")) {
                    spanId = UUID.randomUUID().toString();
                    setAttribute.invoke(request, "spanId", spanId);
                    attributes.put("spanId", spanId);
                } else {
                    spanId = attributes.get("spanId").toString();
                }
                String method = "";
                String requestURI = "";
                String requestURL = "";
                if (getMethod != null) {
                    method = (String)getMethod.invoke(request, new Object[0]);
                }
                if (getRequestURI != null) {
                    requestURI = (String)getRequestURI.invoke(request, new Object[0]);
                }
                if (getRequestURL != null) {
                    Object rawURL = getRequestURL.invoke(request, new Object[0]);
                    requestURL = rawURL instanceof StringBuffer ? ((StringBuffer)rawURL).toString() : (String)rawURL;
                }
                return new JavaObjectNamespace(new servletContext(method, requestURI, requestURL, headers, attributes, spanId));
            }
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("ServletContext Not Found : " + t.getMessage(), new Object[0]);
        }
        RookLogger.Instance().debug("ServletContext Not Found", new Object[0]);
        return new JavaObjectNamespace(null);
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "dump": {
                return this.GetDump();
            }
        }
        return new JavaObjectNamespace(null);
    }

    private class servletContext {
        private String method;
        private String requestURI;
        private String requestURL;
        private String spanId;
        private HashMap<String, Object> headers;
        private HashMap<String, Object> attributes;

        public servletContext(String method, String requestURI, String requestURL, HashMap<String, Object> headers, HashMap<String, Object> attributes, String spanId) {
            this.method = method;
            this.requestURL = requestURL;
            this.requestURI = requestURI;
            this.headers = headers;
            this.attributes = attributes;
            this.spanId = spanId;
        }
    }
}

