/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.StackTrace;

import com.rookout.rook.Services.StackTrace.StackTraceProvider;

public class StackTrace {
    private int baseFrame = 0;
    private Throwable throwable;

    public StackTrace(Throwable java8_and_below_throwable) {
        this.throwable = java8_and_below_throwable;
    }

    public StackTraceElement getBaseFrame() {
        int maxDepth = this.baseFrame + 1;
        StackTraceElement[] elements = StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, maxDepth);
        if (elements.length == 0) {
            return new StackTraceElement("Unavailable", "Unavailable", "Unavailable", -1);
        }
        return elements[0];
    }

    public StackTraceElement[] getTraceback() {
        return StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame);
    }

    public StackTraceElement[] getTraceback(int maxDepth) {
        return StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, maxDepth);
    }

    public StackTraceElement slowGetFrame(int i) {
        int frameIndex = this.baseFrame + i;
        StackTraceElement[] elements = StackTraceProvider.getStackTraceElements(this.throwable, this.baseFrame, frameIndex + 1);
        if (elements.length != 0 && i < elements.length) {
            return elements[i];
        }
        return null;
    }

    public void setBaseFrameIndex(int i) {
        this.baseFrame = i;
    }
}

