/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Utils;
import com.rookout.rook.VersionInfo;

public class Config {
    public String LoggingConfiguration$FILE_NAME = "rookout/java-rook.log";
    public boolean LoggingConfiguration$LOG_TO_STDERR = false;
    public String LoggingConfiguration$LOG_LEVEL = "INFO";
    public boolean LoggingConfiguration$DEBUG = false;
    public String VersionConfiguration$VERSION = VersionInfo.VERSION;
    public String VersionConfiguration$COMMIT = VersionInfo.COMMIT;
    public String GitConfiguration$COMMIT = null;
    public String GitConfiguration$ORIGIN = null;
    public String ControllerAddress$HOST = "wss://control.rookout.com";
    public int ControllerAddress$PORT = 443;
    public boolean MonitorConfiguration$ENABLED = false;
    public Double AgentComConfiguration$BACK_OFF = 0.2;
    public Double AgentComConfiguration$RESET_BACKOFF_TIMEOUT = 180.0;
    public Integer AgentCom$TIMEOUT = 10;
    public Integer AgentCom$PING_TIMEOUT = 10000;
    public Integer AgentCom$CONNECTION_TIMEOUT = 4;
    public Integer AgentCom$MAX_SLEEP = 60;
    public Integer AgentComConfiguration$MAX_QUEUED_MESSAGES = 100;
    public Integer AgentComConfiguration$MAX_MESSAGE_SIZE = 0x100000;
    public Integer OutputWsConfiguration$MAX_STATUS_UPDATES = 200;
    public Integer OutputWsConfiguration$BUCKET_REFRESH_RATE = 10;
    public Integer OutputWsConfiguration$MAX_AUG_MESSAGES = 100;
    public Integer OutputWsConfiguration$MAX_LOG_ITEMS = 200;
    public Double OutputConfiguration$FLUSH_TIME_INTERVAL = 0.25;
    public Integer ClassReloaderConfiguration$MAX_CLASS_COUNT_FOR_LOCATION = 15;
    public Integer ClassReloaderConfiguration$RATE_LIMITER_BEAT_PERIOD = 10000;
    private String ClassReloaderKeyName = "ROOKOUT_RELOAD_CLASSES_INTERVAL";
    public String ClassReloaderConfiguration$THREAD_NAME = "rookout_class_reloader_thread";
    private String ColdFusionConfigurationKeyName = "ROOKOUT_COLD_FUSION_FOLDER";
    public String ColdFusionConfiguration$WWW_ROOT_FOLDER = Utils.GetConfigurationString(this.ColdFusionConfigurationKeyName);
    public long InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = 100L;
    public long InstrumentationConfig$MAX_AUG_TIME = 400L;
    public boolean InstrumentationConfig$CLASS_LOAD_VERBOSE = false;
    public double RateLimiter$MIN_RATE_LIMIT_VALUE_MS = 0.1;
    public int RateLimiter$MODIFIER = 5;
    private static Config instance = null;

    public static Config Instance() {
        if (null == instance) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        String classReloaderInterval;
        String rate_limit;
        if (this.ColdFusionConfiguration$WWW_ROOT_FOLDER == null) {
            this.ColdFusionConfiguration$WWW_ROOT_FOLDER = "";
        }
        if ((rate_limit = Utils.GetConfigurationString("ROOK_RULE_RATE_LIMIT")) != null) {
            try {
                this.InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = Long.parseLong(rate_limit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((classReloaderInterval = Utils.GetConfigurationString(this.ClassReloaderKeyName)) != null) {
            try {
                this.ClassReloaderConfiguration$RATE_LIMITER_BEAT_PERIOD = Integer.parseInt(classReloaderInterval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

