/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Instrumentation.AugVisitor;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.analysis.Analyzer;
import rook.org.objectweb.asm.tree.analysis.AnalyzerException;
import rook.org.objectweb.asm.tree.analysis.BasicValue;
import rook.org.objectweb.asm.tree.analysis.BasicVerifier;

abstract class BaseVisitor
extends ClassVisitor {
    protected Boolean allowSkip = false;
    protected final String className;
    protected final ClassLoader classLoader;

    BaseVisitor(int opcode, ClassLoader classLoader, String className, ClassVisitor classVisitor) {
        super(opcode, classVisitor);
        this.classLoader = classLoader;
        this.className = className;
    }

    public void DisableSkip() {
        this.allowSkip = true;
    }

    protected void verify(MethodNode methodNode) {
        BasicVerifier verifier = new BasicVerifier();
        Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
        try {
            a.analyze(this.className, methodNode);
        }
        catch (AnalyzerException e) {
            throw new AugVisitor.BytecodeVerificationException("Error while transforming method", e);
        }
        try {
            this.classLoader.loadClass("com.rookout.agent.StaticCallback");
        }
        catch (ClassNotFoundException e) {
            throw new AugVisitor.ClassLoadingVerificationException(e);
        }
    }

    abstract boolean isHooked();

    static class IgnoreClassException
    extends AssertionError {
        IgnoreClassException() {
        }
    }
}

