/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Services.StackTrace.StackTrace;

public class LogRecord {
    private int CALLBACK_DEPTH = 2;
    public String module;
    public long time;
    public String msg;
    public String levelname;
    public final long thread_id;
    public final String thread_name;
    public String filename = "";
    public String function = "";
    public int lineno = -1;

    public LogRecord(String module, long time, String message, String levelName) {
        this.module = module;
        this.time = time;
        this.msg = message;
        this.levelname = levelName;
        this.thread_id = Thread.currentThread().getId();
        this.thread_name = Thread.currentThread().getName();
        this.setLogCallerInfo();
    }

    private void setLogCallerInfo() {
        StackTraceElement logCallerStackTraceElement = this.getLogCallerStackTraceElement();
        if (logCallerStackTraceElement != null) {
            this.filename = LogRecord.getValueOrDefault(logCallerStackTraceElement.getFileName(), "");
            this.function = LogRecord.getValueOrDefault(logCallerStackTraceElement.getMethodName(), "");
            this.lineno = LogRecord.getValueOrDefault(logCallerStackTraceElement.getLineNumber(), -1);
        }
    }

    private StackTraceElement getLogCallerStackTraceElement() {
        StackTrace stackTrace = new StackTrace(new Throwable());
        StackTraceElement[] stackTraceElements = stackTrace.getTraceback();
        for (int i = 0; i < stackTraceElements.length - this.CALLBACK_DEPTH; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            if (LoggingService.GetCallback(stackTraceElement.getClassName(), stackTraceElement.getMethodName()) == null) continue;
            return stackTraceElements[i + this.CALLBACK_DEPTH];
        }
        return null;
    }

    private static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

