/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.LogCache;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.LogRecordNamespace;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.LogRecord;
import com.rookout.rook.Services.Logging.LoggingService;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.objectweb.asm.Type;

public class CallbackDispatcher {
    private static CallbackDispatcher instance;
    private LogCache logCache;
    private final Augs augs;
    static final String CallbackDescriptor;
    static final String LogCallbackDispatcher;
    static final String ExpectedLogDispatcher = "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V";

    static void CreateCallbackDispatcher(Augs augs) {
        if (null != instance) {
            throw new RuntimeException("Cannot create CallbackDispatcher twice");
        }
        instance = new CallbackDispatcher(augs);
    }

    static void Close() {
        instance = null;
    }

    public void Callback(String[] augIds, HashMap<String, Object> locals) throws Throwable {
        try {
            long now = System.nanoTime();
            for (String augId : augIds) {
                LocationFileLine location = this.augs.GetAugById(augId);
                if (null != location) {
                    location.Execute(locals, null, now);
                    continue;
                }
                String msg = "Failed to find aug: " + augId;
                if (this.logCache.ShouldSilenceLog(msg)) {
                    return;
                }
                RookLogger.Instance().fatal(msg, new Object[0]);
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    public void LogCallback(String fqcn, Object level, Object marker, String message, Throwable throwable) {
        try {
            long now = System.nanoTime();
            ContainerNamespace extracted = new ContainerNamespace();
            LogRecordNamespace logRecord = new LogRecordNamespace(new LogRecord("Log4J", (double)System.currentTimeMillis() / 1000.0, message, level.toString()));
            extracted.WriteAttribute("log_record", logRecord);
            LoggingService.DispatchLog(extracted, now);
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    private CallbackDispatcher(Augs augs) {
        this.augs = augs;
        this.logCache = new LogCache(10);
    }

    static {
        CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String[].class), Type.getType(HashMap.class));
        LogCallbackDispatcher = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.getType(Object.class), Type.getType(Object.class), Type.getType(String.class), Type.getType(Throwable.class));
    }
}

