/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class LoggingService {
    private static LoggingService instance;
    public static HashMap<String, LocationLogHandler> locations;
    public static HashMap<String, String[][]> HOOK_CLASSES_TO_METHODS_CALLBACKS;

    public static LoggingService Build() {
        instance = new LoggingService();
        return instance;
    }

    public static LoggingService Instance() {
        if (instance == null) {
            LoggingService.Build();
        }
        return instance;
    }

    public void Close() {
    }

    public synchronized void AddAug(LocationLogHandler location) throws Exception {
        locations.put(location.getAugId(), location);
    }

    public synchronized void RemoveAug(String locationId) {
        locations.remove(locationId);
    }

    public ArrayList<LocationLogHandler> GetLocations() {
        return new ArrayList<LocationLogHandler>(locations.values());
    }

    public synchronized void ClearAugs() {
        for (String locationId : locations.keySet()) {
            this.RemoveAug(locationId);
        }
    }

    public static Boolean ShouldHook(String className) {
        if (null == instance) {
            return false;
        }
        className = LoggingService.prepareClassName(className);
        return LoggingService.GetClassesToHook().contains(className);
    }

    public static void DispatchLog(ContainerNamespace extracted, long startTime) {
        ArrayList<LocationLogHandler> locations = LoggingService.Instance().GetLocations();
        if (locations.size() > 0) {
            locations.get(0).Execute(null, extracted, startTime);
        }
    }

    public static Set<String> GetClassesToHook() {
        return HOOK_CLASSES_TO_METHODS_CALLBACKS.keySet();
    }

    public static ArrayList<String> GetHookClassMethodsCallbacks(String className) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks == null) {
            return null;
        }
        ArrayList<String> methodsNames = new ArrayList<String>();
        for (String[] methodCallbacks : methodsCallbacks) {
            methodsNames.add(methodCallbacks[0]);
        }
        return methodsNames;
    }

    public static String GetCallback(String className, String methodName) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks != null) {
            for (String[] methodCallbacks : methodsCallbacks) {
                if (!methodCallbacks[0].equals(methodName)) continue;
                return methodCallbacks[1];
            }
        }
        return null;
    }

    private static String prepareClassName(String className) {
        String preparedClassName = className.replace('/', '.');
        preparedClassName = preparedClassName.replace('\\', '.');
        return preparedClassName;
    }

    static {
        locations = new HashMap();
        HOOK_CLASSES_TO_METHODS_CALLBACKS = new HashMap<String, String[][]>(){
            {
                this.put("org.apache.logging.log4j.spi.AbstractLogger", new String[][]{{"logIfEnabled", "Log4JLogIfEnabledCallback"}});
            }
        };
    }
}

