/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Instrumentation.BaseVisitor;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import com.rookout.rook.Services.Logging.LoggingService;
import java.util.ArrayList;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.VarInsnNode;

public class LoggingVisitor
extends BaseVisitor {
    private boolean isHooked = false;

    LoggingVisitor(String className, ClassLoader classLoader, BaseVisitor augVisitor) {
        super(589824, classLoader, className, augVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        ArrayList<String> methodAndCallback = LoggingService.GetHookClassMethodsCallbacks(this.className);
        if (methodAndCallback == null || !methodAndCallback.get(0).equals(name)) {
            return methodVisitor;
        }
        return new MethodNode(327680, access, name, descriptor, signature, exceptions){

            @Override
            public void visitEnd() {
                String callback = LoggingService.GetCallback(LoggingVisitor.this.className, this.name);
                if (callback != null) {
                    if (this.desc.equals("(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V")) {
                        InsnList hook = this.BuildHook(callback);
                        this.instructions.insert(hook);
                    }
                    LoggingVisitor.this.isHooked = true;
                    LoggingVisitor.this.verify(this);
                }
                super.visitEnd();
                this.accept(methodVisitor);
            }

            private InsnList BuildHook(String callback) {
                Type[] argumentsTypes;
                InsnList hook = new InsnList();
                int argumentIndex = 1;
                for (Type argumentType : argumentsTypes = Type.getArgumentTypes(this.desc)) {
                    String descriptor = argumentType.getDescriptor();
                    hook.add(new VarInsnNode(VisitorUtils.GetOpcode(descriptor), argumentIndex));
                    if (descriptor.equals("D") || descriptor.equals("J")) {
                        argumentIndex += 2;
                        continue;
                    }
                    ++argumentIndex;
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", callback, CallbackDispatcher.LogCallbackDispatcher, false));
                if (this.maxStack <= argumentIndex) {
                    this.maxStack = argumentIndex + 1;
                }
                return hook;
            }
        };
    }

    @Override
    boolean isHooked() {
        return this.isHooked;
    }
}

