/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import java.util.Timer;
import java.util.TimerTask;

public class RateLimiter
implements AutoCloseable {
    public static final int FAST_TOKENS_PER_BEAT = 200;
    public static final int SLOW_RECOVERY_RATIO = 4;
    static final int SLOW_TOKENS_PER_BEAT = 50;
    public static final double FAST_TOKEN_REPLENISH_RATE = 5.5;
    public static final int MAX_TOKENS = 1100;
    public static final int MAX_FAST_RATIO = 2;
    static final int MAX_FAST = 2200;
    public static final int FAST_RECOVERY_RATIO = 30;
    static final int RECOVER_FAST_PER_BEAT = 73;
    static final long WAIT_PERIOD = 2500L;
    Timer timer = new Timer("rookout-token-timer", true);
    int tokens = 1100;
    int fast_tokens_replenish = 2200;

    public RateLimiter(long beat_period) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RateLimiter.this.Beat();
            }
        }, beat_period, beat_period);
    }

    @Override
    public void close() throws Exception {
        this.timer.cancel();
    }

    public void RemoveTokens(int count) {
        while (!this.AttemptRemoveTokens(count)) {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean AttemptRemoveTokens(int count) {
        if (this.tokens > count) {
            this.tokens -= count;
            return true;
        }
        return false;
    }

    private synchronized void Beat() {
        if (this.tokens == 1100) {
            this.fast_tokens_replenish = RateLimiter.min(this.fast_tokens_replenish + 73, 2200);
        } else if (this.fast_tokens_replenish > 0) {
            this.tokens = RateLimiter.min(this.tokens + 200, 1100);
            this.fast_tokens_replenish -= 200;
        } else {
            this.tokens = RateLimiter.min(this.tokens + 50, 1100);
        }
    }

    static int min(int a, int b) {
        return a > b ? b : a;
    }
}

