/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class LoggingService {
    private static LoggingService instance;
    public static HashMap<String, LocationLogHandler> locations;
    public static HashMap<String, String[][]> HOOK_CLASSES_TO_METHODS_CALLBACKS;

    public static LoggingService Build() {
        instance = new LoggingService();
        return instance;
    }

    public static LoggingService Instance() {
        if (instance == null) {
            LoggingService.Build();
        }
        return instance;
    }

    public void Close() {
    }

    public synchronized void AddAug(LocationLogHandler location) throws Exception {
        locations.put(location.getAugId(), location);
        location.SetActive();
    }

    public synchronized void RemoveAug(String locationId) {
        locations.remove(locationId);
    }

    public ArrayList<LocationLogHandler> GetLocations() {
        return new ArrayList<LocationLogHandler>(locations.values());
    }

    public synchronized void ClearAugs() {
        for (String locationId : locations.keySet()) {
            this.RemoveAug(locationId);
        }
    }

    public static Boolean ShouldHook(String className) {
        if (null == instance) {
            return false;
        }
        className = LoggingService.prepareClassName(className);
        return LoggingService.GetClassesToHook().contains(className);
    }

    public static void DispatchLog(ContainerNamespace extracted, long startTime) {
        ArrayList<LocationLogHandler> locations = LoggingService.Instance().GetLocations();
        if (locations.size() > 0) {
            locations.get(0).Execute(null, extracted, startTime);
        }
    }

    public static Set<String> GetClassesToHook() {
        return HOOK_CLASSES_TO_METHODS_CALLBACKS.keySet();
    }

    public static ArrayList<String> GetHookClassMethodsCallbacks(String className) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks == null) {
            return null;
        }
        ArrayList<String> methodsNames = new ArrayList<String>();
        for (String[] methodCallbacks : methodsCallbacks) {
            methodsNames.add(methodCallbacks[0]);
        }
        return methodsNames;
    }

    public static String[] GetMethodCallbackInfo(String className, String methodName, String methodDescriptor) {
        String[][] methodsCallbacks = HOOK_CLASSES_TO_METHODS_CALLBACKS.get(className = LoggingService.prepareClassName(className));
        if (methodsCallbacks != null) {
            for (String[] methodCallbacks : methodsCallbacks) {
                if (!methodCallbacks[0].equals(methodName) || methodDescriptor != null && !methodCallbacks[1].equals(methodDescriptor)) continue;
                return Arrays.copyOfRange(methodCallbacks, 2, methodCallbacks.length);
            }
        }
        return null;
    }

    public static String GetCallback(String className, String methodName, String methodDescriptor) {
        String[] methodCallbackInfo = LoggingService.GetMethodCallbackInfo(className, methodName, methodDescriptor);
        if (methodCallbackInfo != null) {
            return methodCallbackInfo[1];
        }
        return null;
    }

    private static String prepareClassName(String className) {
        String preparedClassName = className.replace('/', '.');
        preparedClassName = preparedClassName.replace('\\', '.');
        return preparedClassName;
    }

    static {
        locations = new HashMap();
        HOOK_CLASSES_TO_METHODS_CALLBACKS = new HashMap<String, String[][]>(){
            {
                this.put("org.apache.logging.log4j.spi.AbstractLogger", new String[][]{{"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith1ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith2ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith3ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith4ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith5ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith6ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith7ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith8ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith9ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Log4JLogIfEnabledWith10ParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;[Ljava/lang/Object;)V", "Log4JLogIfEnabledWithParamsArrayCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/CharSequence;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledCharSequenceCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/CharSequence;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/message/Message;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageTypeCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageObjectCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;)V", "Log4JLogIfEnabledNoThrowableCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Ljava/lang/String;[Lorg/apache/logging/log4j/util/Supplier;)V", "Log4JLogIfEnabledSuppliersArrayAsParamsCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/util/Supplier;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledSupplierAsMessageThrowableCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"logIfEnabled", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;Lorg/apache/logging/log4j/util/MessageSupplier;Ljava/lang/Throwable;)V", "Log4JLogIfEnabledMessageSupplierThrowableCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"}});
                this.put("org.apache.log4j.Category", new String[][]{{"debug", "(Ljava/lang/Object;)V", "Log4JCategoryDebug", "(Ljava/lang/Object;)V"}, {"debug", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryDebugThrowable", "(Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"info", "(Ljava/lang/Object;)V", "Log4JCategoryInfo", "(Ljava/lang/Object;)V"}, {"info", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryInfoThrowable", "(Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"warn", "(Ljava/lang/Object;)V", "Log4JCategoryWarning", "(Ljava/lang/Object;)V"}, {"warn", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryWarningThrowable", "(Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"error", "(Ljava/lang/Object;)V", "Log4JCategoryError", "(Ljava/lang/Object;)V"}, {"error", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryErrorThrowable", "(Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"fatal", "(Ljava/lang/Object;)V", "Log4JCategoryFatal", "(Ljava/lang/Object;)V"}, {"fatal", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "Log4JCategoryFatalThrowable", "(Ljava/lang/Object;Ljava/lang/Throwable;)V"}});
                this.put("ch.qos.logback.classic.Logger", new String[][]{{"filterAndLog_1", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_1Callback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"filterAndLog_2", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_2Callback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V"}, {"filterAndLog_0_Or3Plus", "(Ljava/lang/String;Lorg/slf4j/Marker;Lch/qos/logback/classic/Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)V", "LogBackFilterAndLog_0_Or3PlusCallback", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)V"}});
            }
        };
    }
}

