/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.Instrumentation.LogRecord;

public class LogRecordNamespace
extends JavaObjectNamespace {
    private LogRecord logRecordInstance;
    private static final String lineNumberField = "lineno";
    private static final String filenameField = "filename";
    private static final String functionField = "function";
    private static final String messageField = "msg";
    private static final String levelNameField = "levelname";

    public LogRecordNamespace(LogRecord logRecord) {
        super(logRecord);
        this.logRecordInstance = (LogRecord)this.obj;
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        this.PrepareLogRecordForReadingAttribute(name);
        return super.ReadAttribute(name);
    }

    private void PrepareLogRecordForReadingAttribute(String name) {
        switch (name) {
            case "filename": 
            case "lineno": 
            case "function": {
                this.logRecordInstance.setLogCallerInfo();
                break;
            }
            case "msg": {
                this.logRecordInstance.formatLog();
                break;
            }
            case "levelname": {
                this.logRecordInstance.getLevelName();
            }
        }
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "format": {
                return this.format();
            }
            case "dump": {
                return this.dump();
            }
        }
        return super.CallMethod(name, args);
    }

    public JavaObjectNamespace format() {
        return new JavaObjectNamespace(this.logRecordInstance.getMessage());
    }

    public Namespace dump() throws Exceptions.ToolException {
        this.logRecordInstance.setLogCallerInfo();
        ContainerNamespace dump = new ContainerNamespace();
        dump.WriteAttribute(filenameField, new JavaObjectNamespace(this.logRecordInstance.filename));
        dump.WriteAttribute(functionField, new JavaObjectNamespace(this.logRecordInstance.function));
        dump.WriteAttribute(lineNumberField, new JavaObjectNamespace(this.logRecordInstance.lineno));
        dump.WriteAttribute("time", new JavaObjectNamespace(this.logRecordInstance.time));
        dump.WriteAttribute("formatted_message", this.format());
        dump.WriteAttribute("module", new JavaObjectNamespace(this.logRecordInstance.module));
        dump.WriteAttribute(messageField, new JavaObjectNamespace(this.logRecordInstance.getMessage()));
        dump.WriteAttribute("level_name", new JavaObjectNamespace(this.logRecordInstance.getLevelName()));
        dump.WriteAttribute("module", new JavaObjectNamespace(this.logRecordInstance.module));
        dump.WriteAttribute("thread_id", new JavaObjectNamespace(this.logRecordInstance.thread_id));
        dump.WriteAttribute("thread_name", new JavaObjectNamespace(this.logRecordInstance.thread_name));
        return dump;
    }
}

