/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.Instrumentation.LogRecord;
import com.rookout.rook.protobuf.VariantOuterClass;

public class LogRecordNamespace
extends Namespace {
    public final LogRecord logRecordInstance;
    private static final String lineNumberField = "lineno";
    private static final String filenameField = "filename";
    private static final String functionField = "function";
    private static final String messageField = "msg";
    private static final String levelNameField = "levelname";

    public LogRecordNamespace(LogRecord logRecord) {
        this.logRecordInstance = logRecord;
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        this.PrepareLogRecordForReadingAttribute(name);
        return super.ReadAttribute(name);
    }

    private void PrepareLogRecordForReadingAttribute(String name) {
        switch (name) {
            case "filename": 
            case "lineno": 
            case "function": {
                this.logRecordInstance.setLogCallerInfo();
                break;
            }
            case "msg": {
                this.logRecordInstance.formatLog();
                break;
            }
            case "levelname": {
                this.logRecordInstance.getLevelName();
            }
        }
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "format": {
                return this.format();
            }
        }
        return super.CallMethod(name, args);
    }

    public JavaObjectNamespace format() {
        return new JavaObjectNamespace(this.logRecordInstance.getMessage());
    }

    public void dumpToVariant(VariantOuterClass.Variant.Builder variant) throws Exceptions.ToolException {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIVETAIL);
        this.logRecordInstance.setLogCallerInfo();
        VariantOuterClass.Variant.LiveTailMessage.Builder log_record = VariantOuterClass.Variant.LiveTailMessage.newBuilder();
        log_record.setFilename(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.filename, "unavailable"));
        log_record.setFunction(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.function, "unavailable"));
        log_record.setLineno(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.lineno, -1));
        log_record.setTime(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.time, -1.0));
        log_record.setFormattedMessage(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setModule(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.module, "unavailable"));
        log_record.setMsg(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setLevelName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getLevelName(), "unavailable"));
        log_record.setThreadId(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_id, -1L));
        log_record.setThreadName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_name, "unavailable"));
        variant.setLivetail(log_record);
    }

    public static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

