/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Services.StackTrace.StackTrace;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Pattern;

public class LogRecord {
    private final int CALLBACK_DEPTH = 2;
    private final Object unparsed_msg;
    private final Object levelname_as_obj;
    private final Object _this;
    public HashMap<String, String> log_context;
    public String module;
    public int type;
    public double time;
    public String msg;
    public String levelname;
    public final long thread_id;
    public final String thread_name;
    public String filename = "";
    public String function = "";
    public int lineno = -1;
    public Object[] params;

    public LogRecord(Object _this, int type, double time, Object message, Object levelName, String module, Object ... params) {
        this.unparsed_msg = message;
        this.msg = null;
        this.levelname_as_obj = levelName;
        this.levelname = null;
        this.params = params;
        this.type = type;
        this.time = time;
        this.module = module;
        this.thread_id = Thread.currentThread().getId();
        this.thread_name = Thread.currentThread().getName();
        this._this = _this;
        this.log_context = null;
    }

    public String getLevelName() {
        if (this.levelname == null) {
            this.levelname = this.levelname_as_obj.toString();
        }
        return this.levelname;
    }

    public String getMessage() {
        if (this.msg == null) {
            this.formatLog();
        }
        return this.msg;
    }

    public void formatLog() {
        if (this.msg != null) {
            return;
        }
        switch (this.type) {
            case 1: {
                if (this.unparsed_msg instanceof String) {
                    this.msg = (String)this.unparsed_msg;
                    break;
                }
                this.msg = this.unparsed_msg.toString();
                break;
            }
            case 2: {
                this.msg = LogRecord.FormatMessage(String.valueOf(this.unparsed_msg), this.params);
                break;
            }
            case 3: {
                Object param = LogRecord.getValueFromLambda(this.params[0]);
                this.msg = (String)param;
                break;
            }
            case 4: {
                Object[] params = LogRecord.getValuesFromLambdas(this.params);
                this.msg = LogRecord.FormatMessage(String.valueOf(this.unparsed_msg), params);
                break;
            }
            case 5: {
                this.msg = LogRecord.getFormattedMessageFromLog4jMessageClass(this.unparsed_msg);
                break;
            }
        }
    }

    private static String getFormattedMessageFromLog4jMessageClass(Object message) {
        if (message == null) {
            return null;
        }
        try {
            Method method = message.getClass().getMethod("getFormattedMessage", new Class[0]);
            method.setAccessible(true);
            return String.valueOf(method.invoke(message, new Object[0]));
        }
        catch (Exception e) {
            return "<missing>";
        }
    }

    private static Object[] getValuesFromLambdas(Object ... suppliers) {
        if (suppliers == null) {
            return null;
        }
        Object[] result = new Object[suppliers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = LogRecord.getValueFromLambda(suppliers[i]);
        }
        return result;
    }

    public static Object getValueFromLambda(Object supplier) {
        if (supplier == null) {
            return null;
        }
        try {
            Method method = supplier.getClass().getMethod("get", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke(supplier, new Object[0]);
            if (result instanceof String) {
                return result;
            }
            return LogRecord.getFormattedMessageFromLog4jMessageClass(result);
        }
        catch (Exception e) {
            return "<missing>";
        }
    }

    private static String ParseMessageParam(Object message) {
        try {
            Method method = message.getClass().getMethod("getFormattedMessage", new Class[0]);
            method.setAccessible(true);
            return (String)method.invoke(message, new Object[0]);
        }
        catch (Exception e) {
            return "<missing>";
        }
    }

    private static String FormatMessage(String message, Object ... params) {
        try {
            int i = 0;
            while (message.contains("{}")) {
                Object param = params[i];
                message = message.replaceFirst(Pattern.quote("{}"), String.valueOf(param));
                ++i;
            }
            return message;
        }
        catch (Exception e) {
            return message;
        }
    }

    public void setMdcData() {
        if (this.log_context == null) {
            try {
                Class<?> mdcClass = this._this.getClass().getClassLoader().loadClass("org.slf4j.MDC");
                Method getCopyOfContextMap = mdcClass.getMethod("getCopyOfContextMap", new Class[0]);
                Object contextAsObject = getCopyOfContextMap.invoke(null, new Object[0]);
                if (contextAsObject instanceof HashMap) {
                    this.log_context = (HashMap)contextAsObject;
                }
            }
            catch (Throwable t) {
                this.log_context = null;
            }
        }
    }

    public void setLogCallerInfo() {
        if (this.filename.length() != 0 || this.function.length() != 0 || this.lineno != -1) {
            return;
        }
        StackTraceElement logCallerStackTraceElement = this.getLogCallerStackTraceElement();
        if (logCallerStackTraceElement != null) {
            this.filename = LogRecord.getValueOrDefault(logCallerStackTraceElement.getFileName(), "");
            this.function = LogRecord.getValueOrDefault(logCallerStackTraceElement.getMethodName(), "");
            this.lineno = LogRecord.getValueOrDefault(logCallerStackTraceElement.getLineNumber(), -1);
        }
    }

    private StackTraceElement getLogCallerStackTraceElement() {
        StackTrace stackTrace = new StackTrace(new Throwable());
        StackTraceElement[] stackTraceElements = stackTrace.getTraceback();
        for (int i = 0; i < stackTraceElements.length - 2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            if (LoggingService.GetCallback(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), null) == null) continue;
            return stackTraceElements[i + 2];
        }
        return null;
    }

    private static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static final class LogMessageParsingType {
        public static final int ConvertObjectToString = 1;
        public static final int FormatParamsIntoString = 2;
        public static final int InvokeLambda = 3;
        public static final int InvokeLambdasArrayAndFormatIntoString = 4;
        public static final int ParseLog4jMessageType = 5;
    }
}

