/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs.Locations;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.LogCache;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.TriggerServices;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.WarningReporter;
import java.util.HashMap;
import java.util.logging.Level;

public abstract class Location
implements WarningReporter {
    private OutputWs output;
    Aug aug;
    private boolean deleted = false;
    private String status = "";
    private LogCache logCache = new LogCache(10);

    Location(OutputWs output, Aug aug) {
        this.output = output;
        this.aug = aug;
    }

    public abstract void AddAug(TriggerServices var1);

    public void Execute(HashMap<String, Object> locals, Namespace extracted, long now) {
        if (this.deleted) {
            return;
        }
        try (UserWarnings reporter = new UserWarnings(this);){
            this.aug.Execute(locals, extracted, now, this.output);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getAugId() {
        return this.aug.augId;
    }

    public String getStatus() {
        return this.status;
    }

    public void MarkDeleted() {
        this.deleted = true;
    }

    public boolean IsDeleted() {
        return this.deleted;
    }

    public void SetActive() {
        this.SendRuleStatus("Active", null);
    }

    public void SetPending() {
        this.SendRuleStatus("Pending", null);
    }

    public void SetRemoved() {
        this.SendRuleStatus("Deleted", null);
    }

    public void SetError(RookError error) {
        this.SendRuleStatus("Error", error);
    }

    public void SetUnknown(RookError error) {
        this.SendRuleStatus("Unknown", error);
    }

    @Override
    public void SendWarning(RookError error) {
        if (this.logCache.ShouldSilenceLog(error.getMessage())) {
            return;
        }
        RookLogger.Instance().warn(error.getMessage(), new Object[0]);
        if (null != this.output) {
            this.output.SendWarning(this.getAugId(), error);
        }
    }

    @Override
    public void SendError(RookError error) {
        RookLogger.Instance().log(Level.SEVERE, error.getMessage());
        this.SetError(error);
    }

    protected void SendRuleStatus(String status, RookError error) {
        if (this.status.equals(status)) {
            return;
        }
        RookLogger.Instance().log(Level.INFO, "Updating rule status for: " + this.getAugId() + " to " + status);
        this.status = status;
        if (null != this.output) {
            this.output.SendRuleStatus(this.getAugId(), status, error);
        }
    }
}

