/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.Envelope;
import com.rookout.rook.Processor.NamespaceSerializer2;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.protobuf.Messages;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import rook.com.google.protobuf.ByteString;
import rook.com.google.protobuf.CodedOutputStream;
import rook.com.google.protobuf.Descriptors;
import rook.com.google.protobuf.RookoutBinaryWriter;
import rook.com.google.protobuf.RookoutUtils;
import rook.com.google.protobuf.Timestamp;

public class StreamingEnvelope
implements Envelope {
    private final String agentId;
    private final String augId;
    private final String reportId;
    private final Timestamp timestamp = RookoutUtils.dateToTimestamp(new Date());
    private RookoutBinaryWriter writer;
    private NamespaceSerializer2 serializer;
    byte[] envelope = null;
    static final String AUG_REPORT_MESSAGE_URL = StreamingEnvelope.getTypeUrl("type.googleapis.com", Messages.AugReportMessage.getDescriptor());

    public static StreamingEnvelope Build(String agentId, String augId, String reportId, Namespace arguments) throws IOException {
        RookoutBinaryWriter writer = RookoutUtils.GetBinaryWriter();
        NamespaceSerializer2 serializer = new NamespaceSerializer2();
        serializer.writeNamespace(writer, 8, arguments, true);
        serializer.FinalizeBufferCache();
        return new StreamingEnvelope(agentId, augId, reportId, writer, serializer);
    }

    @Override
    public int length() {
        return this.writer.getTotalBytesWritten() + this.serializer.getEstimatedPendingBytes();
    }

    @Override
    public byte[] toByteArray() throws Exception {
        if (null == this.envelope) {
            this.completeMessage();
            int messageLength = this.writer.getTotalBytesWritten();
            int anyOverallLength = CodedOutputStream.computeStringSize(1, AUG_REPORT_MESSAGE_URL) + CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeUInt32SizeNoTag(messageLength) + messageLength;
            int envelopLength = CodedOutputStream.computeMessageSize(1, this.timestamp) + CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeUInt32SizeNoTag(anyOverallLength) + anyOverallLength;
            this.envelope = new byte[envelopLength];
            CodedOutputStream stream = CodedOutputStream.newInstance(this.envelope);
            stream.writeMessage(1, this.timestamp);
            stream.writeTag(2, 2);
            stream.writeUInt32NoTag(anyOverallLength);
            stream.writeString(1, AUG_REPORT_MESSAGE_URL);
            stream.writeTag(2, 2);
            stream.writeUInt32NoTag(messageLength);
            RookoutUtils.CopyBinaryWriterToArray(this.writer, this.envelope, stream.getTotalBytesWritten());
            this.writer = null;
            this.serializer = null;
        }
        return this.envelope;
    }

    private StreamingEnvelope(String agentId, String augId, String reportId, RookoutBinaryWriter writer, NamespaceSerializer2 serializer) {
        this.agentId = agentId;
        this.augId = augId;
        this.reportId = reportId;
        this.writer = writer;
        this.serializer = serializer;
    }

    private void completeMessage() throws IOException {
        List<ByteString> buffers;
        this.writer.writeString(1, this.agentId);
        this.writer.writeString(2, this.augId);
        this.writer.writeString(4, this.reportId);
        HashMap<String, Integer> strings = this.serializer.getStringCache();
        if (!strings.isEmpty()) {
            this.writer.writeMap(5, RookoutUtils.mapMetaData, this.serializer.getStringCache());
        }
        if (!(buffers = this.serializer.getBuffers()).isEmpty()) {
            for (ByteString buffer : buffers) {
                this.writer.writeBytes(6, buffer);
            }
            this.writer.writeUInt32List(7, this.serializer.getBufferIndices(), true);
        }
        this.writer.writeUInt32(9, 1);
    }

    private static String getTypeUrl(String typeUrlPrefix, Descriptors.Descriptor descriptor) {
        return typeUrlPrefix.endsWith("/") ? typeUrlPrefix + descriptor.getFullName() : typeUrlPrefix + "/" + descriptor.getFullName();
    }
}

