/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.ClassTransformUserWarnings;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.ActiveLocations;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.BaseVisitor;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.CollectionNodesMap;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import com.rookout.rook.Utils;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassWriter;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.LdcInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.TypeInsnNode;

class AugVisitor
extends BaseVisitor {
    private final Files files;
    private final Augs augs;
    private final ActiveLocations activeLocations;
    List<Type> interfaces;
    Type superType;
    private String fileName;
    private final URL sourceLocation;
    private Files.ClassObject classObject;
    private boolean isCfm = false;
    private boolean hookedClass = false;
    private Augs.AugsInFile validAugs;
    private ActiveLocations.Locations finalLocations = new ActiveLocations.Locations();
    private final CollectionNodesMap collectionNodes = new CollectionNodesMap();
    private static final int maxFixes = 20;
    private int fixCount = 0;

    AugVisitor(Files files, Augs augs, ActiveLocations activeLocations, ClassLoader classLoader, String className, URL sourceLocation, ClassWriter classWriter) {
        super(589824, classLoader, className, classWriter);
        this.files = files;
        this.augs = augs;
        this.activeLocations = activeLocations;
        this.sourceLocation = sourceLocation;
        this.interfaces = null;
        this.superType = null;
        this.validAugs = new Augs.AugsInFile();
    }

    @Override
    boolean isHooked() {
        return this.hookedClass;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (null != file) {
            if (file.startsWith("<")) {
                this.fileName = file;
            } else {
                try {
                    String classNamePath;
                    String[] classNamePathSplit;
                    String classNamePathFileName;
                    String fileNameWithoutExtension;
                    Path filePath = Paths.get(file, new String[0]);
                    this.fileName = filePath.getFileName().toString();
                    if (Utils.IsClojureFile(file).booleanValue() && (fileNameWithoutExtension = Utils.GetNameWithoutExtension(this.fileName)).equals(classNamePathFileName = (classNamePathSplit = (classNamePath = Utils.GetClassNamePath(this.className)).split("/"))[classNamePathSplit.length - 1])) {
                        int slashIndex = classNamePath.lastIndexOf("/");
                        String newPath = slashIndex == -1 ? "" : classNamePath.substring(0, slashIndex);
                        this.fileName = newPath + "/" + this.fileName;
                    }
                }
                catch (InvalidPathException e) {
                    this.fileName = file;
                }
            }
            this.classObject = this.files.AddClass(this.classLoader, this.fileName, this.className);
            this.isCfm = Utils.IsColdFusionFile(this.fileName);
        }
        boolean augsToRemove = false;
        for (Map.Entry entry : this.augs.GetAugs(this.fileName).entrySet()) {
            Augs.AugList augList = (Augs.AugList)((Augs.AugList)entry.getValue()).clone();
            for (LocationFileLine location : augList) {
                try {
                    if (location.IsDeleted()) {
                        augsToRemove = true;
                        continue;
                    }
                    this.addAugInValidPosition(location);
                }
                catch (Throwable e) {
                    String message = "Exception while initializing aug during visitSource on aug";
                    RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                    location.SetError(new RookError(e, message));
                }
            }
        }
        if (!this.allowSkip.booleanValue() && this.validAugs.isEmpty() && !augsToRemove) {
            throw new BaseVisitor.IgnoreClassException();
        }
    }

    private void addAugInValidPosition(LocationFileLine location) {
        int updatedLineNo = location.getLineno();
        if (HashCheck.shouldValidateHash(location)) {
            updatedLineNo = HashCheck.GetUpdatedLineNumber(location, this.className, this.classLoader);
        }
        if (updatedLineNo != -1) {
            Augs.AugList validAugsList = (Augs.AugList)this.validAugs.get(updatedLineNo);
            if (validAugsList != null) {
                validAugsList.add(location);
            } else {
                Augs.AugList newAugList = new Augs.AugList();
                newAugList.add(location);
                this.validAugs.put(updatedLineNo, newAugList);
            }
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superType = superName == null ? null : Type.getObjectType(superName);
        this.interfaces = new ArrayList<Type>();
        for (String anInterface : interfaces) {
            this.interfaces.add(Type.getObjectType(anInterface));
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.allowSkip.booleanValue() && null == this.fileName) {
            throw new BaseVisitor.IgnoreClassException();
        }
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            boolean hookMethod() {
                boolean hookedMethod = false;
                ArrayList<Integer> hookedLines = new ArrayList<Integer>();
                Iterator insn = this.instructions.iterator();
                while (insn.hasNext()) {
                    Augs.AugList augList;
                    AbstractInsnNode node = (AbstractInsnNode)insn.next();
                    if (node.getType() != 15) continue;
                    LineNumberNode lineNumberNode = (LineNumberNode)node;
                    if (hookedLines.contains(lineNumberNode.line) || (augList = (Augs.AugList)AugVisitor.this.validAugs.get(lineNumberNode.line)) == null || augList.isEmpty()) continue;
                    for (LocationFileLine location : augList) {
                        ClassTransformUserWarnings.addReporter(AugVisitor.this.className, location);
                    }
                    int currentNode = this.instructions.get(insn.nextIndex()).getType();
                    while (currentNode == 14 || currentNode == 3) {
                        node = (AbstractInsnNode)insn.next();
                        currentNode = this.instructions.get(insn.nextIndex()).getType();
                    }
                    RookLogger.Instance().log(Level.INFO, "Hooking: " + this.name + " ; " + this.desc + " ; " + this.signature);
                    InsnList hook = this.BuildHook(lineNumberNode, augList);
                    this.instructions.insert(node, hook);
                    AugVisitor.this.finalLocations.addAll(augList);
                    hookedMethod = true;
                    AugVisitor.this.hookedClass = true;
                    hookedLines.add(lineNumberNode.line);
                }
                if (hookedMethod) {
                    this.maxStack += 6;
                }
                return hookedMethod;
            }

            boolean canFixHook(AbstractInsnNode badNode) {
                return badNode == null || AugVisitor.this.collectionNodes.containsKey(badNode);
            }

            void fixHookedMethod(AbstractInsnNode badNode) {
                if (badNode == null) {
                    return;
                }
                if (AugVisitor.this.collectionNodes.containsKey(badNode)) {
                    List insnList = (List)AugVisitor.this.collectionNodes.get(badNode);
                    for (AbstractInsnNode node : insnList) {
                        this.instructions.remove(node);
                        AugVisitor.this.collectionNodes.remove(node);
                    }
                }
            }

            boolean tryFixHook() {
                try {
                    AugVisitor.this.verify(this);
                }
                catch (BaseVisitor.BytecodeVerificationException e) {
                    if (AugVisitor.this.fixCount >= 20) {
                        throw new MaxFixCountReachedException("Max fix count reached", (Throwable)((Object)e));
                    }
                    if (!this.canFixHook(e.badNode)) {
                        throw e;
                    }
                    this.fixHookedMethod(e.badNode);
                    AugVisitor.this.fixCount++;
                    return true;
                }
                return false;
            }

            @Override
            public void visitEnd() {
                boolean hookedMethod = this.hookMethod();
                if (hookedMethod) {
                    while (this.tryFixHook()) {
                    }
                }
                super.visitEnd();
                this.accept(methodVisitor);
            }

            private InsnList BuildHook(LineNumberNode hookNode, Augs.AugList augs) {
                InsnList hook = new InsnList();
                hook.add(VisitorUtils.PushInt(augs.size()));
                hook.add(new TypeInsnNode(189, Type.getInternalName(String.class)));
                hook.add(new InsnNode(89));
                for (int i = 0; i < augs.size(); ++i) {
                    hook.add(VisitorUtils.PushInt(i));
                    hook.add(new LdcInsnNode(((LocationFileLine)augs.get(i)).getAugId()));
                    hook.add(new InsnNode(83));
                    hook.add(new InsnNode(89));
                }
                hook.remove(hook.getLast());
                hook.add(new TypeInsnNode(187, Type.getInternalName(HashMap.class)));
                hook.add(new InsnNode(89));
                hook.add(new MethodInsnNode(183, Type.getInternalName(HashMap.class), "<init>", "()V", false));
                LocalVariableInfo[] variables = new LocalVariableInfo[this.maxLocals];
                for (int i = 0; i < variables.length; ++i) {
                    variables[i] = new LocalVariableInfo();
                }
                VisitorUtils.LoadArguments(variables, this.name, this.desc, this.access);
                this.ScanMethod(hookNode, variables);
                CollectionNodesMap newCollectionNodes = VisitorUtils.CollectVariables(variables, hook, AugVisitor.this.isCfm);
                if (newCollectionNodes.isEmpty()) {
                    RookLogger.Instance().log(Level.INFO, "No locals found - parsing variables from disk");
                    newCollectionNodes = VisitorUtils.ParseLocalVariablesFromDisk(AugVisitor.this.sourceLocation, hook, hookNode, AugVisitor.this.className, this.name, this.desc, AugVisitor.this.isCfm);
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", "Callback", CallbackDispatcher.CallbackDescriptor, false));
                if (newCollectionNodes != null) {
                    AugVisitor.this.collectionNodes.putAll(newCollectionNodes);
                }
                return hook;
            }

            private void ScanMethod(LineNumberNode hookNode, LocalVariableInfo[] variables) {
                AbstractInsnNode insnIterator;
                Iterator it = this.instructions.iterator();
                while (it.hasNext() && (insnIterator = (AbstractInsnNode)it.next()) != hookNode) {
                    VisitorUtils.ParseVariblesFromNodes(insnIterator, variables, this.localVariables, this.name, AugVisitor.this.superType);
                }
            }
        };
    }

    @Override
    public void visitEnd() {
        this.activeLocations.SetAllLocations(this.finalLocations, this.classObject);
        super.visitEnd();
    }

    static class MaxFixCountReachedException
    extends AssertionError {
        MaxFixCountReachedException(String message, Throwable cause) {
            super(message + " :: " + cause.getMessage(), cause);
        }
    }
}

