/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import rook.com.google.common.collect.BiMap;
import rook.com.google.common.collect.HashBiMap;

class Files {
    FileMapping fileMapping = new FileMapping();
    FilePathMapping filePathMapping = new FilePathMapping();
    private static PrefixIdMapping prefixIdMapping = new PrefixIdMapping();
    private static final int NO_PREFIX_FOUND = 0;

    Files() {
    }

    synchronized ClassObject AddClass(ClassLoader classLoader, String fileName, String className) {
        int fileNameHash = 0;
        ClassSet classSet = null;
        if (Utils.IsClojureFile(fileName).booleanValue()) {
            classSet = (ClassSet)this.filePathMapping.get(fileName);
        } else {
            fileNameHash = this.getFileNameHash(fileName);
            classSet = (ClassSet)this.fileMapping.get(fileNameHash);
        }
        if (null == classSet) {
            classSet = new ClassSet();
            if (fileNameHash == 0) {
                this.filePathMapping.put(fileName, classSet);
            } else {
                this.fileMapping.put(fileNameHash, classSet);
            }
        }
        ClassObject classObject = new ClassObject(classLoader, className);
        classSet.add(classObject);
        return classObject;
    }

    synchronized ClassSet GetClasses(String fileName) {
        if (Utils.IsClojureFile(fileName).booleanValue()) {
            if (this.filePathMapping.containsKey(fileName)) {
                return (ClassSet)((ClassSet)this.filePathMapping.get(fileName)).clone();
            }
            for (Map.Entry entry : this.filePathMapping.entrySet()) {
                String classFilePath = (String)entry.getKey();
                if (!fileName.endsWith(classFilePath)) continue;
                return (ClassSet)((ClassSet)entry.getValue()).clone();
            }
        } else {
            int fileNameHash = this.getFileNameHash(fileName);
            if (this.fileMapping.containsKey(fileNameHash)) {
                return (ClassSet)((ClassSet)this.fileMapping.get(fileNameHash)).clone();
            }
        }
        return new ClassSet();
    }

    private int getFileNameHash(String fileName) {
        return fileName.toLowerCase().hashCode();
    }

    private static class PrefixIdMapping {
        private BiMap<ByteBuffer, Integer> prefixMapping = HashBiMap.create();
        private AtomicInteger prefixMappingCurrentIndex = new AtomicInteger(1);

        PrefixIdMapping() {
        }

        int putPrefixAndGetId(String packageName) {
            ByteBuffer packageNameAsBuffer = ByteBuffer.wrap(packageName.getBytes(StandardCharsets.UTF_8));
            Integer prefixIdFromMap = (Integer)this.prefixMapping.get(packageNameAsBuffer);
            if (prefixIdFromMap == null) {
                prefixIdFromMap = this.prefixMappingCurrentIndex.getAndIncrement();
                this.prefixMapping.put(packageNameAsBuffer, prefixIdFromMap);
            }
            return prefixIdFromMap;
        }

        String getPrefix(int prefixId) {
            return new String(((ByteBuffer)this.prefixMapping.inverse().get(prefixId)).array(), StandardCharsets.UTF_8);
        }
    }

    class FilePathMapping
    extends HashMap<String, ClassSet> {
        FilePathMapping() {
        }
    }

    class FileMapping
    extends HashMap<Integer, ClassSet> {
        FileMapping() {
        }
    }

    class ClassSet
    extends HashSet<ClassObject> {
        ClassSet() {
        }
    }

    class ClassObject {
        ClassLoader classLoader;
        private int prefixId;
        private byte[] baseClassName;

        ClassObject(ClassLoader classLoader, String className) {
            this.classLoader = classLoader;
            int baseClassNameIndex = className.lastIndexOf(47);
            if (baseClassNameIndex == -1) {
                baseClassNameIndex = 0;
                this.prefixId = 0;
            } else {
                String packageName = className.substring(0, baseClassNameIndex);
                this.prefixId = prefixIdMapping.putPrefixAndGetId(packageName);
            }
            this.baseClassName = className.substring(baseClassNameIndex).getBytes(StandardCharsets.UTF_8);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassObject)) {
                return false;
            }
            ClassObject other = (ClassObject)obj;
            return this.classLoader == other.classLoader && this.prefixId == other.prefixId && Arrays.equals(this.baseClassName, other.baseClassName);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.prefixId, Arrays.hashCode(this.baseClassName));
        }

        public String getClassName() {
            String decodedBaseClassName = new String(this.baseClassName, StandardCharsets.UTF_8);
            if (this.prefixId == 0) {
                return decodedBaseClassName;
            }
            return prefixIdMapping.getPrefix(this.prefixId) + decodedBaseClassName;
        }
    }
}

