/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Config;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class RateLimiter
implements AutoCloseable {
    public static final int FAST_TOKENS_PER_BEAT = 200;
    public static final int SLOW_RECOVERY_RATIO = 4;
    static final int SLOW_TOKENS_PER_BEAT = 50;
    public static final double FAST_TOKEN_REPLENISH_RATE = 5.5;
    public static final int MAX_TOKENS = 1100;
    public static final int MAX_FAST_RATIO = 2;
    static final int MAX_FAST = 2200;
    public static final int FAST_RECOVERY_RATIO = 30;
    static final int RECOVER_FAST_PER_BEAT = 73;
    Timer timer = null;
    int tokens = 1100;
    int fast_tokens_replenish = 2200;
    int beat_period = 0;
    AtomicInteger monitored_beat_period = null;

    public RateLimiter(AtomicInteger _monitored_beat_period) {
        this.monitored_beat_period = _monitored_beat_period;
        this.Schedule(this.monitored_beat_period.get());
    }

    private void Schedule(int period) {
        this.timer = new Timer("rookout-token-timer", true);
        this.beat_period = period;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RateLimiter.this.Beat();
            }
        }, period, (long)period);
    }

    @Override
    public void close() throws Exception {
        this.timer.cancel();
    }

    public void RemoveTokens(int count) {
        while (!this.AttemptRemoveTokens(count)) {
            try {
                Thread.sleep(Config.Instance().ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_WAIT_PERIOD.get());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean AttemptRemoveTokens(int count) {
        if (this.tokens > count) {
            this.tokens -= count;
            return true;
        }
        return false;
    }

    private synchronized void Beat() {
        if (this.tokens == 1100) {
            this.fast_tokens_replenish = RateLimiter.min(this.fast_tokens_replenish + 73, 2200);
        } else if (this.fast_tokens_replenish > 0) {
            this.tokens = RateLimiter.min(this.tokens + 200, 1100);
            this.fast_tokens_replenish -= 200;
        } else {
            this.tokens = RateLimiter.min(this.tokens + 50, 1100);
        }
        if (this.monitored_beat_period.get() != this.beat_period) {
            this.timer.cancel();
            this.Schedule(this.monitored_beat_period.get());
        }
    }

    static int min(int a, int b) {
        return a > b ? b : a;
    }
}

