/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.ClassTransformUserWarnings;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.MethodNode;

class LocalsParserVisitor
extends ClassVisitor {
    private String funcName;
    private String desc;
    private LocalVariableInfo[] variables = null;
    Type superType;
    LineNumberNode hookNode;
    private boolean foundLine;

    LocalsParserVisitor(LineNumberNode hookNode, String funcName, String desc) {
        super(589824);
        this.funcName = funcName;
        this.superType = null;
        this.hookNode = hookNode;
        this.desc = desc;
        this.foundLine = false;
    }

    public LocalVariableInfo[] GetLocalVariables() {
        return this.variables;
    }

    public boolean DidFindLine() {
        return this.foundLine;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superType = superName == null ? null : Type.getObjectType(superName);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (!name.equals(this.funcName) || !this.desc.equals(desc)) {
            return methodVisitor;
        }
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitEnd() {
                LocalsParserVisitor.access$002(LocalsParserVisitor.this, new LocalVariableInfo[this.maxLocals]);
                for (int i = 0; i < LocalsParserVisitor.this.variables.length; ++i) {
                    ((LocalsParserVisitor)LocalsParserVisitor.this).variables[i] = new LocalVariableInfo();
                }
                VisitorUtils.LoadArguments(LocalsParserVisitor.this.variables, this.name, this.desc, this.access);
                for (AbstractInsnNode insnIterator : this.instructions) {
                    if (insnIterator.getType() == 15) {
                        LineNumberNode lineNumberNode = (LineNumberNode)insnIterator;
                        if (lineNumberNode.line == LocalsParserVisitor.this.hookNode.line) {
                            LocalsParserVisitor.this.foundLine = true;
                            if (this.maxLocals <= 0 || this.localVariables.size() != 0) break;
                            ClassTransformUserWarnings.SendTransformWarning(new RookError(new Exceptions.RookMissingDebugInfoVariable()));
                            break;
                        }
                    }
                    VisitorUtils.ParseVariblesFromNodes(insnIterator, LocalsParserVisitor.this.variables, this.localVariables, this.name, LocalsParserVisitor.this.superType);
                }
                for (LocalVariableInfo lv : LocalsParserVisitor.this.variables) {
                    if (lv.name == null) continue;
                    RookLogger.Instance().debug("Found local: " + lv.name, new Object[0]);
                }
                this.accept(methodVisitor);
            }
        };
    }

    static /* synthetic */ LocalVariableInfo[] access$002(LocalsParserVisitor x0, LocalVariableInfo[] x1) {
        x0.variables = x1;
        return x1;
    }
}

