/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import com.rookout.rook.UserWarnings;
import java.net.URL;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.Label;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.tree.MethodNode;

public class VisitorFindLocation
extends ClassVisitor {
    private final LocationFileLine location;
    private final String className;
    private final ClassLoader classLoader;
    private int updatedLineNo = 0;
    private boolean lineNumbers = false;
    private boolean lineFound = false;

    VisitorFindLocation(LocationFileLine location, String className, ClassLoader classLoader) {
        super(589824);
        this.location = location;
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (HashCheck.shouldValidateHash(this.location)) {
            this.updatedLineNo = HashCheck.GetUpdatedLineNumber(this.location, this.className, this.classLoader);
            if (-1 == this.updatedLineNo) {
                // empty if block
            }
        } else {
            this.updatedLineNo = this.location.getLineno();
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitLineNumber(int line, Label start) {
                VisitorFindLocation.this.lineNumbers = true;
                if (line == VisitorFindLocation.this.updatedLineNo) {
                    VisitorFindLocation.this.lineFound = true;
                }
                super.visitLineNumber(line, start);
            }
        };
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    static boolean ContainLocation(URL classUrl, String className, ClassLoader classLoader, LocationFileLine location) {
        Boolean cacheResult = location.getClassMatchFromCache(classUrl);
        if (cacheResult != null) {
            return cacheResult;
        }
        VisitorFindLocation visitor = new VisitorFindLocation(location, className, classLoader);
        boolean lineFound = false;
        try {
            ClassReader reader = new ClassReader(classUrl.openStream());
            reader.accept(visitor, 0);
            if (!visitor.lineNumbers) {
                UserWarnings.SendWarning(new RookError(new Exceptions.RookMissingDebugInfoLines()));
            }
            lineFound = visitor.lineFound;
        }
        catch (Throwable e) {
            lineFound = true;
        }
        location.addClassMatchToCache(classUrl, lineFound);
        return lineFound;
    }
}

