/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.Envelope;
import com.rookout.rook.Config;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Queue {
    public static AtomicInteger maxMessageSize = new AtomicInteger(Queue.getMaxMessageSize());
    private int maxQueueLength = Queue.getMaxQueueLength();
    protected LinkedBlockingQueue<Envelope> pendingMessages = new LinkedBlockingQueue(this.maxQueueLength);
    protected AtomicInteger pendingMessagesSize = new AtomicInteger();
    private boolean shouldLog = true;

    protected Queue() {
    }

    void offer(Envelope envelope) {
        if (!this.TryAllocateMemoryInQueue(envelope.length())) {
            return;
        }
        this.pendingMessages.offer(envelope);
    }

    Envelope poll(long timeout, TimeUnit unit) {
        if (this.pendingMessages.isEmpty()) {
            this.shouldLog = true;
        }
        Envelope envelope = null;
        try {
            envelope = this.pendingMessages.poll(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (null == envelope) {
            return null;
        }
        this.pendingMessagesSize.addAndGet(-envelope.length());
        return envelope;
    }

    private synchronized boolean TryAllocateMemoryInQueue(int length) {
        if (this.pendingMessages.size() > this.maxQueueLength || this.pendingMessagesSize.get() + length > Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE.get()) {
            if (this.shouldLog) {
                this.shouldLog = false;
                RookLogger.Instance().warn("Max queue limits were reached (%d/%d, %d/%d) - Dumping message", this.pendingMessages.size(), this.maxQueueLength, this.pendingMessagesSize.get() + length, Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE.get());
            }
            return false;
        }
        this.pendingMessagesSize.addAndGet(length);
        return true;
    }

    private static int getMaxMessageSize() {
        String maxMessageSizeString = Utils.GetConfigurationString("ROOKOUT_MAX_MESSAGE_SIZE");
        if (maxMessageSizeString != null) {
            try {
                int maxMessageSize = Integer.parseInt(maxMessageSizeString);
                if (maxMessageSize > Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.get()) {
                    return maxMessageSize;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.get();
    }

    private static int getMaxQueueLength() {
        return Config.Instance().AgentComConfiguration$MAX_QUEUED_MESSAGES;
    }

    public boolean isFull() {
        return this.pendingMessages.size() >= this.maxQueueLength || this.pendingMessagesSize.get() >= Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE.get();
    }
}

