/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AugRateLimiter {
    private final Config config;
    public final long windowSize;
    public final long quota;
    private final long activeWeight;
    private int activeCount = 0;
    private boolean sendWarning = true;
    private final Map<Long, Long> windows = new LinkedHashMap<Long, Long>();

    public AugRateLimiter(long quota, long windowSize, int activeLimit) {
        this.quota = quota;
        this.windowSize = windowSize > 0L ? windowSize : 1L;
        this.activeWeight = 0 != activeLimit ? quota / (long)activeLimit : 0L;
        this.config = Config.Instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean BeforeRun(long startTime) {
        long current_window_key = AugRateLimiter.floorDiv(startTime, this.windowSize) * this.windowSize;
        Long prev_window_key = current_window_key - this.windowSize;
        boolean rateLimited = false;
        AugRateLimiter augRateLimiter = this;
        synchronized (augRateLimiter) {
            this.cleanup(startTime);
            ++this.activeCount;
            if (this.quota > 0L && this.currentUsage(startTime, current_window_key, prev_window_key) > this.quota) {
                --this.activeCount;
                rateLimited = true;
            }
        }
        if (!rateLimited) {
            return true;
        }
        if (this.sendWarning) {
            UserWarnings.SendWarning(new RookError(Exceptions.RookRuleRateLimited()));
            this.sendWarning = false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AfterRun(long startTime) {
        long current_window_key = AugRateLimiter.floorDiv(startTime, this.windowSize) * this.windowSize;
        long duration = Math.max(System.nanoTime() - startTime, Utils.DoubleMSToNS(this.config.RateLimiter$MIN_RATE_LIMIT_VALUE_MS));
        AugRateLimiter augRateLimiter = this;
        synchronized (augRateLimiter) {
            --this.activeCount;
            this.RecordUsage(current_window_key, duration);
        }
    }

    private void RecordUsage(long current_window_key, long duration) {
        Long total_usage = this.windows.get(current_window_key);
        if (total_usage != null) {
            this.windows.put(current_window_key, total_usage + duration);
        }
    }

    private long currentUsage(Long startTime, Long currentWindowKey, Long prevWindowKey) {
        Long prev_window_usage;
        Long current_window_usage = this.windows.get(currentWindowKey);
        if (current_window_usage == null) {
            this.windows.put(currentWindowKey, 0L);
            current_window_usage = 0L;
        }
        if (null == (prev_window_usage = this.windows.get(prevWindowKey))) {
            prev_window_usage = 0L;
        }
        float prevWeight = 1.0f - (float)(startTime - currentWindowKey) / (float)this.windowSize;
        return (long)((float)prev_window_usage.longValue() * prevWeight) + (long)this.activeCount * this.activeWeight + current_window_usage;
    }

    private void cleanup(long startTime) {
        if (this.windows.size() > 10) {
            Iterator<Map.Entry<Long, Long>> it = this.windows.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Long> entry = it.next();
                Long key = entry.getKey();
                if (key >= startTime - this.windowSize * 5L) continue;
                it.remove();
            }
        }
    }

    private static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }
}

