/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.ComUtils;
import com.rookout.rook.ComWs.NotImplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;

public class ProxySocketFactory
extends SocketFactory {
    private String proxyAddress;
    private String host;
    private int proxyPort;
    private int port;
    private boolean secure;

    public ProxySocketFactory(String proxyAddress, int proxyPort, String host, int port, boolean secure) {
        this.port = port;
        this.secure = secure;
        this.host = host;
        this.proxyAddress = proxyAddress;
        this.proxyPort = proxyPort;
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        Socket tunnel = new Socket(this.proxyAddress, this.proxyPort);
        this.doTunnelHandshake(tunnel, this.host, this.port);
        if (this.secure) {
            try {
                return ComUtils.CreateSslSocketFactory().createSocket(tunnel, this.host, this.port, true);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.toString());
            }
        }
        return tunnel;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\nUser-Agent: RookoutAgent/1.0\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        OutputStream out = tunnel.getOutputStream();
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
            throw new IOException("Unable to tunnel through " + host + ":" + port + ".  Proxy returns \"" + replyStr + "\"");
        }
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        throw new NotImplementedException();
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        throw new NotImplementedException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        throw new NotImplementedException();
    }
}

