/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.ActionRunProcessor;
import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.AugRateLimiter;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.LimitManager;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.util.ArrayList;
import java.util.logging.Level;
import rook.org.json.JSONException;
import rook.org.json.JSONObject;

public class AugFactory {
    private final Config config;
    private OutputWs output;
    public AugRateLimiter globalRateLimiter;
    private ProcessorFactory factory = new ProcessorFactory();

    public AugFactory(OutputWs output) {
        this.output = output;
        this.config = Config.Instance();
    }

    public Location GetAug(String configuration) throws Exceptions.ToolException {
        return this.GetAug(new JSONObject(configuration));
    }

    public Location GetAug(JSONObject configuration) throws Exceptions.ToolException {
        JSONObject jsonObjectLocation;
        ActionRunProcessor action;
        JSONObject jsonObjectAction;
        String augId;
        try {
            augId = configuration.getString("id");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("id", configuration.toString(), t);
        }
        try {
            jsonObjectAction = configuration.getJSONObject("action");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("action", configuration.toString(), t);
        }
        try {
            action = new ActionRunProcessor(jsonObjectAction, this.factory);
        }
        catch (Throwable t) {
            throw new Exceptions.RookInvalidObjectConfiguration("", jsonObjectAction.toString(), t);
        }
        long maxAugTime = Utils.MSToNS(this.config.InstrumentationConfig$MAX_AUG_TIME);
        try {
            maxAugTime = Utils.MSToNS(configuration.getLong("maxAugTime"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        maxAugTime = (long)((double)maxAugTime * Config.Instance().AgentComConfiguration$MAX_AUG_TIME_MULTIPLIER.get());
        Condition condition = null;
        try {
            String conditionConfiguration = configuration.getString("conditional");
            condition = new Condition(conditionConfiguration);
        }
        catch (JSONException conditionConfiguration) {
            // empty catch block
        }
        if (this.globalRateLimiter == null) {
            this.globalRateLimiter = this.CreateGlobalRateLimiter();
        }
        ArrayList<AugRateLimiter> limiters = new ArrayList<AugRateLimiter>();
        if (this.globalRateLimiter != null) {
            limiters.add(this.globalRateLimiter);
        } else {
            AugRateLimiter rateLimiter;
            long windowQuota = Utils.MSToNS(200L);
            long windowSize = Utils.MSToNS(5000L);
            String rateLimitsSpec = null;
            if (configuration.has("rateLimit")) {
                rateLimitsSpec = configuration.getString("rateLimit");
            }
            int rateLimitModifier = 0;
            if (configuration.has("rateLimitModifier")) {
                String rateLimitModifierStr = configuration.getString("rateLimitModifier");
                try {
                    rateLimitModifier = Integer.parseInt(rateLimitModifierStr);
                }
                catch (NumberFormatException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to parse rate limit configuration: ", e, new Object[0]);
                }
            }
            if ((rateLimiter = this.CreateRateLimiter(rateLimitsSpec, windowQuota, windowSize, rateLimitModifier, 1)) != null) {
                limiters.add(rateLimiter);
            }
        }
        LimitManager limitManager = new LimitManager(limiters);
        Aug aug = new Aug(augId, action, condition, maxAugTime, limitManager);
        try {
            jsonObjectLocation = configuration.getJSONObject("location");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("location", configuration.toString(), t);
        }
        return this.getLocation(jsonObjectLocation, aug);
    }

    private AugRateLimiter CreateGlobalRateLimiter() {
        if (this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS == null) {
            return null;
        }
        AugRateLimiter globalRateLimiter = null;
        try {
            globalRateLimiter = this.CreateRateLimiter(this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS, 0L, 0L, 0, this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_MULTIPLIER);
            if (globalRateLimiter == null) {
                throw new Exceptions.RookInvalidRateLimitConfiguration(this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS);
            }
            Config.Instance().GlobalRateLimiter$USING_GLOBAL_RATE_LIMITER = true;
        }
        catch (Exceptions.RookInvalidRateLimitConfiguration e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to create global rate limiter: " + e.getMessage());
            UserWarnings.SendError(new RookError(e, "Failed to create global rate limiter"));
        }
        return globalRateLimiter;
    }

    private AugRateLimiter CreateRateLimiter(String limitsSpec, long defaultQuota, long defaultWindowSize, int activeLimit, int multiplier) throws Exceptions.RookInvalidRateLimitConfiguration {
        String[] limits;
        long quota = defaultQuota;
        long windowSize = defaultWindowSize;
        if (limitsSpec != null && (limits = limitsSpec.split("/")).length == 2) {
            try {
                quota = Utils.MSToNS(Long.parseLong(limits[0], 10));
                windowSize = Utils.MSToNS(Long.parseLong(limits[1], 10));
            }
            catch (NumberFormatException e) {
                quota = defaultQuota;
                windowSize = defaultWindowSize;
            }
        }
        if (quota == 0L) {
            return null;
        }
        if (quota >= windowSize) {
            throw new Exceptions.RookInvalidRateLimitConfiguration(limitsSpec);
        }
        return new AugRateLimiter(quota * (long)multiplier, windowSize, activeLimit);
    }

    private Location getLocation(JSONObject configuration, Aug aug) throws Exceptions.ToolException {
        String name;
        try {
            name = configuration.getString("name");
        }
        catch (Throwable t) {
            throw new Exceptions.RookObjectNameMissing(configuration.toString(), t);
        }
        switch (name) {
            case "file_line": {
                try {
                    return new LocationFileLine(configuration, this.factory, this.output, aug);
                }
                catch (Throwable t) {
                    throw new Exceptions.RookInvalidObjectConfiguration(name, configuration.toString(), t);
                }
            }
            case "log_handler": {
                try {
                    return new LocationLogHandler(this.output, aug);
                }
                catch (Throwable t) {
                    throw new Exceptions.RookInvalidObjectConfiguration(name, configuration.toString(), t);
                }
            }
        }
        throw new Exceptions.RookUnsupportedLocation(name);
    }
}

