/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.AugRateLimiter;
import com.rookout.rook.Augs.LimitManager;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.util.ArrayList;
import java.util.logging.Level;
import rook.org.json.JSONObject;

public class LimitProvider {
    public AugRateLimiter globalRateLimiter;
    public static final LimitProvider instance = new LimitProvider();
    private final Config config = Config.Instance();

    private LimitProvider() {
    }

    public void deleteGlobalRateLimiter() {
        this.globalRateLimiter = null;
    }

    public LimitManager getLimitManager(JSONObject configuration) throws Exceptions.RookInvalidRateLimitConfiguration {
        ArrayList<AugRateLimiter> limiters = new ArrayList<AugRateLimiter>();
        AugRateLimiter rateLimiter = this.getRateLimiter(configuration);
        if (rateLimiter != null) {
            limiters.add(rateLimiter);
        }
        return new LimitManager(limiters, configuration.getString("id"));
    }

    private AugRateLimiter getRateLimiter(JSONObject configuration) throws Exceptions.RookInvalidRateLimitConfiguration {
        if (this.globalRateLimiter != null) {
            return this.globalRateLimiter;
        }
        long windowQuota = Utils.MSToNS(200L);
        long windowSize = Utils.MSToNS(5000L);
        String rateLimitsSpec = null;
        if (configuration.has("rateLimit")) {
            rateLimitsSpec = configuration.getString("rateLimit");
        }
        int rateLimitModifier = 0;
        if (configuration.has("rateLimitModifier")) {
            String rateLimitModifierStr = configuration.getString("rateLimitModifier");
            try {
                rateLimitModifier = Integer.parseInt(rateLimitModifierStr);
            }
            catch (NumberFormatException e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to parse rate limit configuration: ", e, new Object[0]);
            }
        }
        return this.createRateLimiter(rateLimitsSpec, windowQuota, windowSize, rateLimitModifier, 1);
    }

    public void tryToCreateGlobalRateLimiter() {
        AugRateLimiter globalRateLimiter = null;
        try {
            globalRateLimiter = this.createRateLimiter(this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS, 0L, 0L, 0, this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_MULTIPLIER);
            if (globalRateLimiter == null) {
                throw new Exceptions.RookInvalidRateLimitConfiguration(this.config.GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS);
            }
            Config.Instance().GlobalRateLimiter$USING_GLOBAL_RATE_LIMITER = true;
        }
        catch (Exceptions.RookInvalidRateLimitConfiguration e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to create global rate limiter: " + e.getMessage());
            UserWarnings.SendError(new RookError(e, "Failed to create global rate limiter"));
        }
        this.globalRateLimiter = globalRateLimiter;
    }

    private AugRateLimiter createRateLimiter(String limitsSpec, long defaultQuota, long defaultWindowSize, int activeLimit, int multiplier) throws Exceptions.RookInvalidRateLimitConfiguration {
        String[] limits;
        long quota = defaultQuota;
        long windowSize = defaultWindowSize;
        if (limitsSpec != null && (limits = limitsSpec.split("/")).length == 2) {
            try {
                quota = Utils.MSToNS(Long.parseLong(limits[0], 10));
                windowSize = Utils.MSToNS(Long.parseLong(limits[1], 10));
            }
            catch (NumberFormatException e) {
                quota = defaultQuota;
                windowSize = defaultWindowSize;
            }
        }
        if (quota == 0L) {
            return null;
        }
        if (quota >= windowSize) {
            throw new Exceptions.RookInvalidRateLimitConfiguration(limitsSpec);
        }
        return new AugRateLimiter(quota * (long)multiplier, windowSize, activeLimit);
    }
}

