/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Augs.LimitProvider;
import com.rookout.rook.ComWs.Queue;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.VersionInfo;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rook.com.google.common.util.concurrent.AtomicDouble;

public class Config {
    public String LoggingConfiguration$FILE_NAME = "";
    public boolean LoggingConfiguration$LOG_TO_STDERR = false;
    public String LoggingConfiguration$LOG_LEVEL = "INFO";
    public boolean LoggingConfiguration$DEBUG = false;
    public int LoggingConfiguration$MAX_LOG_SIZE = 0x6400000;
    public boolean LoggingConfiguration$QUIET = false;
    public String VersionConfiguration$VERSION = VersionInfo.VERSION;
    public String VersionConfiguration$COMMIT = VersionInfo.COMMIT;
    public String VersionConfiguration$BRANCH = VersionInfo.BRANCH;
    public String GitConfiguration$COMMIT = null;
    public String GitConfiguration$ORIGIN = null;
    public String ControllerAddress$HOST = "wss://control.rookout.com";
    public int ControllerAddress$PORT = 443;
    public boolean MonitorConfiguration$ENABLED = true;
    public Double AgentComConfiguration$BACK_OFF = 0.2;
    public Double AgentComConfiguration$RESET_BACKOFF_TIMEOUT = 180.0;
    public Integer AgentCom$TIMEOUT = 10;
    public Integer AgentCom$PING_TIMEOUT = 10000;
    public Integer AgentCom$CONNECTION_TIMEOUT = 8;
    public Integer AgentCom$MAX_SLEEP = 60;
    public Integer AgentComConfiguration$MAX_QUEUED_MESSAGES = 250;
    public AtomicInteger AgentComConfiguration$MAX_MESSAGE_SIZE = new AtomicInteger(0x100000);
    public AtomicInteger AgentComConfiguration$MAX_QUEUE_SIZE = new AtomicInteger(0xF00000);
    public AtomicDouble AgentComConfiguration$MAX_AUG_TIME_MULTIPLIER = new AtomicDouble(1.0);
    public Integer OutputWsConfiguration$MAX_STATUS_UPDATES = 200;
    public Integer OutputWsConfiguration$BUCKET_REFRESH_RATE = 10;
    public Integer OutputWsConfiguration$MAX_AUG_MESSAGES = 250;
    public Integer OutputWsConfiguration$MAX_LOG_ITEMS = 200;
    public Double OutputConfiguration$FLUSH_TIME_INTERVAL = 0.25;
    public Integer ClassReloaderConfiguration$MAX_CLASS_COUNT_FOR_LOCATION = 15;
    public AtomicInteger ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD = new AtomicInteger(10000);
    private String ClassReloaderKeyName = "ROOKOUT_RELOAD_CLASSES_INTERVAL";
    public String ClassReloaderConfiguration$THREAD_NAME = "rookout_class_reloader_thread";
    public AtomicInteger ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_WAIT_PERIOD = new AtomicInteger(2500);
    private String ColdFusionConfigurationKeyName = "ROOKOUT_COLD_FUSION_FOLDER";
    public String ColdFusionConfiguration$WWW_ROOT_FOLDER;
    public long InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = 100L;
    public long InstrumentationConfig$MAX_AUG_TIME = 400L;
    public boolean InstrumentationConfig$CLASS_LOAD_VERBOSE = false;
    public double RateLimiter$MIN_RATE_LIMIT_VALUE_MS = 0.025;
    public String GlobalRateLimiter$GLOBAL_RATE_LIMIT_QUOTA = "";
    public String GlobalRateLimiter$GLOBAL_RATE_LIMIT_WINDOW_SIZE = "";
    public String GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS = Utils.GetConfigurationString("ROOKOUT_GLOBAL_RATE_LIMIT");
    public int GlobalRateLimiter$GLOBAL_RATE_LIMIT_MULTIPLIER = 2;
    public boolean GlobalRateLimiter$USING_GLOBAL_RATE_LIMITER = false;
    public AtomicBoolean StringCache_UserMessage = new AtomicBoolean(false);
    public AtomicBoolean Protobuf_Version2 = new AtomicBoolean(false);
    public Boolean LiveTail$Enable = false;
    private static Config instance = null;

    public static Config Instance() {
        if (null == instance) {
            instance = new Config();
        }
        return instance;
    }

    private void updateGlobalRateLimitConfig() {
        if (Utils.GetConfigurationString("ROOKOUT_GLOBAL_RATE_LIMIT") != null) {
            RookLogger.Instance().debug("Global rate limit specs already set to " + Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS + " by the env ROOKOUT_GLOBAL_RATE_LIMIT", new Object[0]);
            LimitProvider.instance.tryToCreateGlobalRateLimiter();
            return;
        }
        if (Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS != null) {
            if (Objects.equals(Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_QUOTA, "") && Objects.equals(Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_WINDOW_SIZE, "")) {
                LimitProvider.instance.deleteGlobalRateLimiter();
                RookLogger.Instance().debug("Deleting Global Rate Limit", new Object[0]);
                Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS = "";
            }
            return;
        }
        if (!Objects.equals(Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_QUOTA, "") && !Objects.equals(Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_WINDOW_SIZE, "")) {
            Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS = Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_QUOTA + "/" + Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_WINDOW_SIZE;
            RookLogger.Instance().debug("Updating GLOBAL_RATE_LIMIT_SPECS value to: " + Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_SPECS, new Object[0]);
            LimitProvider.instance.tryToCreateGlobalRateLimiter();
        }
    }

    public static void UpdateConfig(Map<String, String> configurations) {
        for (Map.Entry<String, String> entry : configurations.entrySet()) {
            switch (entry.getKey()) {
                case "JAVA_StringCache_UserMessage": {
                    RookLogger.Instance().debug("Updating StringCache_UserMessage value to: " + entry.getValue(), new Object[0]);
                    Config.Instance().StringCache_UserMessage.set(Boolean.parseBoolean(entry.getValue()));
                    break;
                }
                case "JAVA_DEFAULT_MAX_DEPTH": {
                    try {
                        RookLogger.Instance().debug("Updating DEFAULT_MAX_DEPTH value to: " + entry.getValue(), new Object[0]);
                        JavaObjectNamespace.ObjectDumpConfig.DEFAULT_MAX_DEPTH.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_DEFAULT_MAX_COLLECTION_DEPTH": {
                    try {
                        RookLogger.Instance().debug("Updating DEFAULT_MAX_COLLECTION_DEPTH value to: " + entry.getValue(), new Object[0]);
                        JavaObjectNamespace.ObjectDumpConfig.DEFAULT_MAX_COLLECTION_DEPTH.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_TOLERANT_MAX_DEPTH": {
                    try {
                        RookLogger.Instance().debug("Updating TOLERANT_MAX_DEPTH value to: " + entry.getValue(), new Object[0]);
                        JavaObjectNamespace.ObjectDumpConfig.TOLERANT_MAX_DEPTH.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_TOLERANT_MAX_COLLECTION_DEPTH": {
                    try {
                        RookLogger.Instance().debug("Updating TOLERANT_MAX_COLLECTION_DEPTH value to: " + entry.getValue(), new Object[0]);
                        JavaObjectNamespace.ObjectDumpConfig.TOLERANT_MAX_COLLECTION_DEPTH.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_MAX_MESSAGE_SIZE": {
                    try {
                        RookLogger.Instance().debug("Updating MAX_MESSAGE_SIZE value to: " + entry.getValue(), new Object[0]);
                        Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.set(Integer.parseInt(entry.getValue()));
                        Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE.set(Integer.parseInt(entry.getValue()) * 10);
                        RookLogger.Instance().debug("Updating MAX_QUEUE_SIZE value to: " + Config.Instance().AgentComConfiguration$MAX_QUEUE_SIZE.get(), new Object[0]);
                        Queue.maxMessageSize.set(Config.Instance().AgentComConfiguration$MAX_MESSAGE_SIZE.get());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_PROTOBUF_VERSION_2": {
                    String Protobuf_Version2 = Utils.GetConfigurationString("ROOKOUT_Protobuf_Version2");
                    if (Protobuf_Version2 == null) {
                        RookLogger.Instance().debug("Updating Protobuf_Version2 value to: " + entry.getValue(), new Object[0]);
                        Config.Instance().Protobuf_Version2.set(Boolean.parseBoolean(entry.getValue()));
                        break;
                    }
                    RookLogger.Instance().debug("Updating Protobuf_Version2 value to: " + Protobuf_Version2, new Object[0]);
                    Config.Instance().Protobuf_Version2.set(Boolean.parseBoolean(Protobuf_Version2));
                    break;
                }
                case "JAVA_MAX_AUG_TIME_MULTIPLIER": {
                    try {
                        RookLogger.Instance().debug("Updating MAX_AUG_TIME_MULTIPLIER value to: " + entry.getValue(), new Object[0]);
                        double maxAugTimeMultiplier = Double.parseDouble(entry.getValue());
                        if (maxAugTimeMultiplier >= 1.0 && maxAugTimeMultiplier <= 2.0) {
                            Config.Instance().AgentComConfiguration$MAX_AUG_TIME_MULTIPLIER.set(maxAugTimeMultiplier);
                            break;
                        }
                        RookLogger.Instance().warn("Skipping update of MAX_AUG_TIME_MULTIPLIER since its not in range of 1-2: " + entry.getValue(), new Object[0]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_CLASS_RELOADING_RATE_LIMITER_WAIT_PERIOD": {
                    try {
                        RookLogger.Instance().debug("Updating CLASS_RELOADING_RATE_LIMITER_WAIT_PERIOD value to: " + entry.getValue(), new Object[0]);
                        Config.Instance().ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_WAIT_PERIOD.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD": {
                    try {
                        RookLogger.Instance().debug("Updating CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD value to: " + entry.getValue(), new Object[0]);
                        Config.Instance().ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD.set(Integer.parseInt(entry.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "JAVA_GLOBAL_RATE_LIMIT_QUOTA_MS": {
                    Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_QUOTA = entry.getValue();
                    Config.Instance().updateGlobalRateLimitConfig();
                    break;
                }
                case "JAVA_GLOBAL_RATE_LIMIT_WINDOW_SIZE_MS": {
                    Config.Instance().GlobalRateLimiter$GLOBAL_RATE_LIMIT_WINDOW_SIZE = entry.getValue();
                    Config.Instance().updateGlobalRateLimitConfig();
                }
            }
        }
    }

    private Config() {
        String classReloaderInterval;
        String rate_limit;
        this.ColdFusionConfiguration$WWW_ROOT_FOLDER = Utils.GetConfigurationString(this.ColdFusionConfigurationKeyName);
        if (this.ColdFusionConfiguration$WWW_ROOT_FOLDER == null) {
            this.ColdFusionConfiguration$WWW_ROOT_FOLDER = "";
        }
        if ((rate_limit = Utils.GetConfigurationString("ROOK_RULE_RATE_LIMIT")) != null) {
            try {
                this.InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = Long.parseLong(rate_limit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((classReloaderInterval = Utils.GetConfigurationString(this.ClassReloaderKeyName)) != null) {
            try {
                this.ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD.set(Integer.parseInt(classReloaderInterval));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

